
#include "TimeoutAbs.h"
#include "drivers/TimerEvent.h"
#include "platform/FunctionPointer.h"
#include "hal/ticker_api.h"
#include "platform/mbed_critical.h"

namespace mbed {

void TimeoutAbs::detach()
{
    core_util_critical_section_enter();
    remove();
    // unlocked only if we were attached (we locked it) and this is not low power ticker
    if (_function && _lock_deepsleep) {
        sleep_manager_unlock_deep_sleep();
    }
    _function = 0;
    core_util_critical_section_exit();
}

void TimeoutAbs::abs_setup(us_timestamp_t t)
{
    core_util_critical_section_enter();
    remove();
    insert_absolute(t);
    core_util_critical_section_exit();
}

void TimeoutAbs::handler()
{
    Callback<void()> local = _function;
    detach();
    local.call();
}

} // namespace mbed
