/*
 / _____)             _              | |
( (____  _____ ____ _| |_ _____  ____| |__
 \____ \| ___ |    (_   _) ___ |/ ___)  _ \
 _____) ) ____| | | || |_| ____( (___| | | |
(______/|_____)_|_|_| \__)_____)\____)_| |_|
    (C)2015 Semtech

Description: VT100 serial display management

License: Revised BSD License, see LICENSE.TXT file include in the project

Maintainer: Miguel Luis and Gregory Cristian
*/
#ifndef __SERIAL_DISPLAY_H__
#define __SERIAL_DISPLAY_H__

#include "vt100.h"
#include "LoRaMac1v1.h"

#ifdef ENABLE_VT100

#define ROW_START       5
#ifdef LORAWAN_JOIN_EUI
    #define ROW_DEVEUI          ROW_START
    #define ROW_JOINEUI         (ROW_DEVEUI+1)
    #define ROW_NWKKEY          (ROW_JOINEUI+1)
    #ifdef OPTNEG
        #define ROW_APPKEY          (ROW_JOINEUI+2)
        #define ROW_NwkId           (ROW_JOINEUI+5)
    #else
        #define ROW_NwkId        (ROW_JOINEUI+4)
    #endif
#else
    #define ROW_NwkId           ROW_START       /* ABP */
#endif /* LORAWAN_JOIN_EUI */

#define ROW_DevAddr         (ROW_NwkId+1)
#define ROW_FNwkSIntKey     (ROW_NwkId+2)
#ifdef OPTNEG
    #define ROW_SNwkSIntKey     (ROW_NwkId+3)
    #define ROW_NwkSEncKey      (ROW_NwkId+4)
    #define ROW_AppSKey         (ROW_NwkId+5)
#else
    #define ROW_AppSKey         (ROW_NwkId+3)
#endif

#define ROW_FrameType       (ROW_AppSKey+2)
#define ROW_ADR             (ROW_AppSKey+3)
#define ROW_DUTY            (ROW_AppSKey+4)
#define ROW_PUBLIC          (ROW_AppSKey+6)
#ifdef LORAWAN_JOIN_EUI
    #define ROW_JOINED             (ROW_PUBLIC+1)
    #define ROW_UPLINK_ACKED       (ROW_PUBLIC+3)
#else
    #define ROW_UPLINK_ACKED       (ROW_PUBLIC+2)
#endif /* LORAWAN_JOIN_EUI */

#define ROW_UPLINK_DR       (ROW_UPLINK_ACKED+1)
#define ROW_UPLINK_FCNT      (ROW_UPLINK_DR+1)
#define ROW_UPLINK_PORT     (ROW_UPLINK_DR+2)
#define ROW_UPLINK_PAYLOAD     (ROW_UPLINK_DR+3)

#define ROW_DOWNLINK_RSSI     (ROW_UPLINK_PAYLOAD+5)
#define ROW_DOWNLINK_SNR     (ROW_DOWNLINK_RSSI+1)
#define ROW_DOWNLINK_FCNT     (ROW_DOWNLINK_SNR+1)
#define ROW_DOWNLINK_FPORT     (ROW_DOWNLINK_FCNT+1)
#define ROW_DOWNLINK_PAYLOAD     (ROW_DOWNLINK_FPORT+1)

#define ROW_END             (ROW_DOWNLINK_PAYLOAD+6)

void SerialDisplayInit( void );
void SerialDisplayUplink(uint8_t fport, const uint8_t* buffer, uint8_t bufferSize );
void SerialDisplayMcpsConfirm( const McpsConfirm_t*);
void SerialDisplayMcpsIndication(const McpsIndication_t* mi);
void SerialDisplayPrintCheckBox( bool activated );
#ifdef LORAWAN_JOIN_EUI
void SerialDisplayUpdateActivationMode( bool otaa );
void SerialDisplayUpdateEui( uint8_t line, const uint8_t *eui );
void SerialDisplayUpdateNetworkIsJoined( bool state );
#endif /* LORAWAN_JOIN_EUI */
void SerialDisplayUpdateKey( uint8_t line, const uint8_t *key );
void SerialDisplayUpdateNwkId( uint8_t id );
void SerialDisplayUpdateDevAddr( uint32_t addr );
void SerialDisplayUpdateFrameType( bool confirmed );
void SerialDisplayUpdateAdr( bool adr );
void SerialDisplayUpdateDutyCycle( bool dutyCycle );
void SerialDisplayUpdatePublicNetwork( bool network );
void SerialDisplayUpdateData( const uint8_t *buffer );
void SerialDisplayUpdateUplinkAcked( bool state );
void SerialDisplayUpdateDonwlinkRxData( bool state );
bool SerialDisplayReadable( void );
uint8_t SerialDisplayGetChar( void );
extern VT100 vt;
#endif /* ENABLE_VT100 */

#endif // __SERIAL_DISPLAY_H__
