/*
 / _____)             _              | |
( (____  _____ ____ _| |_ _____  ____| |__
 \____ \| ___ |    (_   _) ___ |/ ___)  _ \
 _____) ) ____| | | || |_| ____( (___| | | |
(______/|_____)_|_|_| \__)_____)\____)_| |_|
    (C)2018 Semtech

Description: End device commissioning parameters

License: Revised BSD License, see LICENSE.TXT file include in the project

*/
#ifndef __LORA_COMMISSIONING_H__
#define __LORA_COMMISSIONING_H__

#define SENETCO

#define USE_BAND_915_HYBRID
//#define USE_BAND_915
//#define USE_BAND_ARIB_8CH
//#define USE_BAND_868
//#define USE_BAND_433
//#define USE_BAND_470
//#define USE_BAND_780


#define ENABLE_VT100

#ifdef ENABLE_VT100
    #define ROW_MLME_IND            (ROW_END+1)
    #define ROW_MLME_CONF           (ROW_END+2)
    #define ROW_MCPS_IND            (ROW_END+3)
    #define ROW_MCPS_CONF           (ROW_END+4)
    #define ROW_MIC                 (ROW_END+5)
#else
    #define ROW_MIC     0
#endif

/*!
 * Indicates if the end-device is to be connected to a private or public network
 */
#define LORAWAN_PUBLIC_NETWORK                      true

#ifdef SENETCO
    #define LORAWAN_DEVICE_EUI       {0x00,0x25,0x0C,0x01,0x00,0x00,0x00,0x08}
    #define LORAWAN_JOIN_EUI         {0x00,0x25,0x0C,0x00,0x00,0x01,0x00,0x01}
    #define LORAWAN_ROOT_NWKKEY      {0x3D,0xFD,0xF3,0x80,0x45,0x0E,0x8B,0x8D,0x3E,0xD5,0x89,0x25,0xAA,0xD4,0x23,0x53}
#else
/*!
 * Mote device IEEE EUI (big endian)
 *
 * \remark In this application the value is automatically generated by calling
 *         BoardGetUniqueId function
 */

#define LORAWAN_DEVICE_EUI       { 0x19,0x51,0x34,0x30,0x9E,0x30,0x6A,0x37 } // home net 000001
//#define LORAWAN_DEVICE_EUI     { 0x3e,0xbe,0x24,0xb1,0x6b,0x7b,0x9c,0xfc } // home net 6000ff
/*!
* Join IEEE EUI (big endian): undefine for ABP
*/
#define LORAWAN_JOIN_EUI         { 0x64,0x7F,0xDA,0x80,0x00,0x00,0x01,0x2E }

/*!
* AES encryption/decryption cipher application key
* 00112233445566778899aabbccddeeff */
#define LORAWAN_ROOT_NWKKEY     { 0x00,0x11,0x22,0x33,0x44,0x55,0x66,0x77,0x88,0x99,0xaa,0xbb,0xcc,0xdd,0xee,0xff }
#endif /* !SENETCO */

// d2fc83ea58cf0fbc973dbd07a7115486     lorawan-1.1 OTA only
//#define LORAWAN_ROOT_APPKEY   { 0xd2,0xfc,0x83,0xea,0x58,0xcf,0x0f,0xbc,0x97,0x3d,0xbd,0x07,0xa7,0x11,0x54,0x86 } // uncomment for lorawan1v1, or comment for lorawan1v0


#ifndef LORAWAN_JOIN_EUI     /* ABP mote: */
    /*
     * AppSkey:     09763a2d1c29831ea073b24d5d12f084
     * FNwkSIntKey: 15aed1b53c90518e1c6170c12a315429
     * SNwkSintKey: 37fe10c4c31a26f9d027180bc192567f  1v1 ABP
     * NwkSEncKey:  f765291c0b18720d9f62a13c4c01ef73  1v1 ABP
     */
    #define LORAWAN_FNwkSIntKey    {0x15, 0xae, 0xd1, 0xb5, 0x3c, 0x90, 0x51, 0x8e, 0x1c, 0x61, 0x70, 0xc1, 0x2a, 0x31, 0x54, 0x29}
    #define LORAWAN_APPSKEY        {0x09, 0x76, 0x3a, 0x2d, 0x1c, 0x29, 0x83, 0x1e, 0xa0, 0x73, 0xb2, 0x4d, 0x5d, 0x12, 0xf0, 0x84}
    //#define LORAWAN_SNwkSIntKey    {0x37, 0xfe, 0x10, 0xc4, 0xc3, 0x1a, 0x26, 0xf9, 0xd0, 0x27, 0x18, 0x0b, 0xc1, 0x92, 0x56, 0x7f} // 1v1
    //#define LORAWAN_NwkSEncKey     {0xf7, 0x65, 0x29, 0x1c, 0x0b, 0x18, 0x72, 0x0d, 0x9f, 0x62, 0xa1, 0x3c, 0x4c, 0x01, 0xef, 0x73} // 1v1
    #if defined(LORAWAN_SNwkSIntKey) && defined(LORAWAN_NwkSEncKey)
        #define OPTNEG
        #define LORAWAN_DEVICE_ADDRESS         ( uint32_t )0x02000555   // 1v1 provisioned netid 000001
        //#define LORAWAN_DEVICE_ADDRESS         ( uint32_t )0xe3fc0555   // 1v1 provisioned netid 6000ff
    #else
        #undef OPTNEG
        #define LORAWAN_DEVICE_ADDRESS         ( uint32_t )0x02000aaa   // 1v0 provisioned
    #endif
#else
    #ifdef LORAWAN_ROOT_APPKEY
        #define OPTNEG
    #else
        #undef OPTNEG
    #endif
#endif

#endif // __LORA_COMMISSIONING_H__

