#include "LoRaMac1v1.h"
#include "LoRaMacString.h"

void
Mlme_to_string(Mlme_t mlme, char* dst)
{
    const char* ptr = NULL;

    switch (mlme) {
        case MLME_NONE: ptr = "NONE"; break;
        case MLME_LINK_CHECK: ptr = "LINK_CHECK"; break;
        case MLME_SWITCH_CLASS: ptr = "SWITCH_CLASS"; break;
        case MLME_PING_SLOT_INFO: ptr = "PING_SLOT_INFO"; break;
        case MLME_BEACON_TIMING: ptr = "BEACON_TIMING"; break;
        case MLME_BEACON_ACQUISITION: ptr = "BEACON_ACQUISITION"; break;
        case MLME_TIME_REQ: ptr = "TIME_REQ"; break;
        case MLME_BEACON: ptr = "BEACON"; break;
        case MLME_TXCW: ptr = "TXCW"; break;
#ifdef LORAWAN_JOIN_EUI
        case MLME_JOIN: ptr = "JOIN"; break;
        case MLME_REJOIN_0: ptr = "REJOIN_0"; break;
        case MLME_REJOIN_1: ptr = "REJOIN_1"; break;
        case MLME_REJOIN_2: ptr = "REJOIN_2"; break;
#endif
    }

    if (ptr != NULL)
        strcpy(dst, ptr);
}

void
LoRaMacEventInfoStatus_to_string(LoRaMacEventInfoStatus_t status, char* dst)
{
    const char* ptr = NULL;

    switch (status) {

        case LORAMAC_EVENT_INFO_STATUS_OK: ptr = "OK"; break;
        case LORAMAC_EVENT_INFO_STATUS_INCR_FAIL: ptr = "INCR_FAIL"; break;
        case LORAMAC_EVENT_INFO_STATUS_MLMEREQ: ptr = "MLMEREQ"; break;
        case LORAMAC_EVENT_INFO_STATUS_UNKNOWN_MTYPE: ptr = "UNKNOWN_MTYPE"; break;
        case LORAMAC_EVENT_INFO_STATUS_SENDING: ptr = "SENDING"; break;
        case LORAMAC_EVENT_INFO_STATUS_MCPSREQ: ptr = "MCPSREQ"; break;
        case LORAMAC_EVENT_INFO_STATUS_TX_TIMEOUT: ptr = "TX_TIMEOUT"; break;
        case LORAMAC_EVENT_INFO_STATUS_RX2_TIMEOUT: ptr = "RX2_TIMEOUT"; break;
        case LORAMAC_EVENT_INFO_STATUS_RX2_ERROR: ptr = "RX2_ERROR"; break;
#ifdef LORAWAN_JOIN_EUI
        case LORAMAC_EVENT_INFO_STATUS_JOIN_FAIL: ptr = "JOIN_FAIL"; break;
        case LORAMAC_EVENT_INFO_STATUS_JOINNONCE: ptr = "JOINNONCE"; break;
#endif
        case LORAMAC_EVENT_INFO_STATUS_DOWNLINK_REPEATED: ptr = "DOWNLINK_REPEATED"; break;
        case LORAMAC_EVENT_INFO_STATUS_TX_DR_PAYLOAD_SIZE_ERROR: ptr = "TX_DR_PAYLOAD_SIZE_ERROR"; break;
        case LORAMAC_EVENT_INFO_STATUS_DOWNLINK_TOO_MANY_FRAMES_LOSS: ptr = "DOWNLINK_TOO_MANY_FRAMES_LOSS"; break;
        case LORAMAC_EVENT_INFO_STATUS_ADDRESS_FAIL: ptr = "ADDRESS_FAIL"; break;
        case LORAMAC_EVENT_INFO_STATUS_MIC_FAIL: ptr = "MIC_FAIL"; break;
        case LORAMAC_EVENT_INFO_STATUS_MULTICAST_FAIL: ptr = "MULTICAST_FAIL"; break;
        case LORAMAC_EVENT_INFO_STATUS_BEACON_LOCKED: ptr = "BEACON_LOCKED"; break;
        case LORAMAC_EVENT_INFO_STATUS_BEACON_LOST: ptr = "BEACON_LOST"; break;
        case LORAMAC_EVENT_INFO_STATUS_BEACON_NOT_FOUND: ptr = "BEACON_NOT_FOUND"; break;
        case LORAMAC_EVENT_INFO_STATUS_NO_APPKEY: ptr = "NO_APPKEY"; break;
        case LORAMAC_EVENT_INFO_BAD_RX_DELAY: ptr = "BAD_RX_DELAY"; break;
        case LORAMAC_EVENT_INFO_STATUS_CHANNEL_BUSY: ptr = "CHANNEL_BUSY"; break;
    }

    if (ptr != NULL)
        strcpy(dst, ptr);
}

void
LoRaMacStatus_to_string(LoRaMacStatus_t status, char* dst)
{
    const char* ptr = NULL;

    switch (status) {
        case LORAMAC_STATUS_OK: ptr = "OK"; break;
        case LORAMAC_STATUS_LSE: ptr = "LSE"; break;
        case LORAMAC_STATUS_WAITING_FOR_TXSTART: ptr = "WAIT_TXSTART"; break;
        case LORAMAC_STATUS_WAITING_FOR_TXDONE: ptr = "WAIT_TXDONE"; break;
        case LORAMAC_STATUS_WAITING_FOR_RX1: ptr = "WAIT_RX1"; break;
        case LORAMAC_STATUS_WAITING_FOR_RX2: ptr = "WAIT_RX2"; break;
        case LORAMAC_STATUS_BUSY_UPCONF: ptr = "BUSY_UPCONF"; break;
        case LORAMAC_STATUS_SERVICE_UNKNOWN: ptr = "SERVICE_UNKNOWN"; break;
        case LORAMAC_STATUS_PARAMETER_INVALID: ptr = "PARAMETER_INVALID"; break;
        case LORAMAC_STATUS_FREQUENCY_INVALID: ptr = "FREQUENCY_INVALID"; break;
        case LORAMAC_STATUS_DATARATE_INVALID: ptr = "DATARATE_INVALID"; break;
        case LORAMAC_STATUS_FREQ_AND_DR_INVALID: ptr = "FREQ_AND_DR_INVALID"; break;
#ifdef LORAWAN_JOIN_EUI
        case LORAMAC_STATUS_NO_NETWORK_JOINED: ptr = "NO_NETWORK_JOINED"; break;
#endif
        case LORAMAC_STATUS_LENGTH_ERROR: ptr = "LENGTH_ERROR"; break;
        case LORAMAC_STATUS_MAC_CMD_LENGTH_ERROR: ptr = "MAC_CMD_LENGTH_ERROR"; break;
        case LORAMAC_STATUS_DEVICE_OFF: ptr = "DEVICE_OFF"; break;
        case LORAMAC_STATUS_EEPROM_FAIL: ptr = "EEPROM_FAIL"; break;
    }
    if (ptr != NULL)
        strcpy(dst, ptr);
}
