#include "x_nucleo_iks01a2.h"
#include "x_nucleo_iks01a2_accelero.h"
#include "x_nucleo_iks01a2_pressure.h"
#include "x_nucleo_iks01a2_temperature.h"

#define SAMPLE_LIST_MAX  10      /*!< Max. number of acceleration values (X,Y,Z) to be printed to UART */
#define FIFO_INDICATION_DELAY  100 /*!< When FIFO event ocurs, LED is ON for at least this period [ms] */

#define LIS2DH_MAIN_NONE        0
#define LIS2DH_BSP_FAIL         1
#define LIS2DH_FAIL             2
#define LIS2DH_FAIL_STATE       3
#define LIS2DH_MAIN_SLEEP       4
#define LIS2DH_MAIN_READ_FIFO       5

#ifdef __cplusplus
extern "C" {
#endif

typedef struct displayFloatToInt_s
{
  int8_t sign; /* 0 means positive, 1 means negative */
  uint32_t out_int;
  uint32_t out_dec;
} displayFloatToInt_t;

int demo_start(void);

int lis2dh_mainloop(void);

uint8_t accel_get_num_samples(void);
int lis2dh_set_fifo_bypass(void);
DrvStatusTypeDef lis2dh12_get_axes(SensorAxes_t *);

void lis2dh_int1(void); // irq callback

void c_log_printf(const char* format, ...);   // from main.cpp
void demo_sample_temp(displayFloatToInt_t*);
void demo_sample_pressure(displayFloatToInt_t*);
int lis2dh_set_fifo_mode(void);
int accel_enable(uint8_t);
int accel_is_enabled(uint8_t* status);

#ifdef __cplusplus
}
#endif
