#include "radio.h"

SPI spi(PA_7, PA_6, PB_3); // mosi, miso, sclk
//                  dio0, dio1,  nss,  spi,  rst
SX127x Radio::radio(PB_4, PB_1, PA_15, spi, PC_0);
SX127x_lora Radio::lora(radio);
SX127x_fsk Radio::fsk(radio);

#define CRF1    PA_1
#define CRF2    PC_2
#define CRF3    PC_1
DigitalOut Vctl1(CRF1);
DigitalOut Vctl2(CRF2);
DigitalOut Vctl3(CRF3);

void Radio::rfsw_callback()
{
    if (radio.RegOpMode.bits.Mode == RF_OPMODE_TRANSMITTER) {
        Vctl1 = 0;
        if (radio.RegPaConfig.bits.PaSelect) {
            Vctl2 = 0;
            Vctl3 = 1;
        } else {
            Vctl2 = 1;
            Vctl3 = 0;
        }
    } else {
        if (radio.RegOpMode.bits.Mode == RF_OPMODE_RECEIVER || radio.RegOpMode.bits.Mode == RF_OPMODE_RECEIVER_SINGLE)
            Vctl1 = 1;
        else
            Vctl1 = 0;

        Vctl2 = 0;
        Vctl3 = 0;
    }
}

void Radio::tx_dbm_print()
{
    int dbm;
    RegPdsTrim1_t pds_trim;
    uint8_t adr, pa_test_adr;

    if (radio.type == SX1276) {
        adr = REG_PDSTRIM1_SX1276;
        pa_test_adr = REG_PATEST_SX1276;
    } else {
        adr = REG_PDSTRIM1_SX1272;
        pa_test_adr = REG_PATEST_SX1272;
    }

    if (radio.read_reg(pa_test_adr) & 0x20) {
        pds_trim.octet = radio.read_reg(adr);

        radio.RegPaConfig.octet = radio.read_reg(REG_PACONFIG);
        if (radio.RegPaConfig.bits.PaSelect) {
            dbm = radio.RegPaConfig.bits.OutputPower + pds_trim.bits.prog_txdac - 2;
        } else {
            dbm = radio.RegPaConfig.bits.OutputPower - 1;
        }
    } else
        dbm = PA_OFF_DBM;

    pc.printf("%d", dbm);
}

bool Radio::tx_dbm_write(const char* str)
{
    int dbm;
    uint8_t adr;
    RegPdsTrim1_t pds_trim;

    sscanf(str, "%d", &dbm);

    if (radio.type == SX1276)
        adr = REG_PDSTRIM1_SX1276;
    else
        adr = REG_PDSTRIM1_SX1272;

    pds_trim.octet = radio.read_reg(adr);

    if (dbm > 14) {
        radio.RegPaConfig.bits.PaSelect = 1;    // PA_BOOST
        if (dbm > 17) {
            dbm -= 3;
            pds_trim.bits.prog_txdac = 7;
            radio.write_reg(adr, pds_trim.octet);
        }
        radio.RegPaConfig.bits.OutputPower = dbm - 2;
    } else {
        radio.RegPaConfig.bits.PaSelect = 0;    // RFO
        radio.RegPaConfig.bits.OutputPower = dbm + 1;
    }

    radio.write_reg(REG_PACONFIG, radio.RegPaConfig.octet);

    return false;
}

void Radio::targetInit()
{
    radio.rf_switch = rfsw_callback;
}
