#include "mbed.h"
// new class to play a note on Speaker based on PwmOut class
class Speaker
{
private:
// sets up specified pin for PWM using PwmOut class 
    PwmOut pin;
    Ticker ticker;
    void flipPin() {
        pin = 0.0;
    }
public:
    Speaker(PinName pin) : pin(pin) {
// _pin(pin) means pass pin to the Speaker Constructor
    }
// class method to play a note based on PwmOut class
    void playNote(float frequency, float duration, float volume) {
        pin.period(1.0/frequency);
        pin = volume/2.0;
        ticker.attach(this, &Speaker::flipPin, duration);
        //wait(duration);
        //pin = 0.0;
    } 

};
 