#include "mbed.h"
#include "rtos.h"
#include "NTPClient.h"

// AM/PM
const int AM = 0;
const int PM = 12;

// Timezones
const int PST = -8;
const int MST = -7;
const int CST = -6;
const int EST = -5;
const int UTC = 0;

class Clock {
public:
    Clock();
    void setAlarmThread(Thread *aThread);
    
    void setTime(int hour, int minute, int period);
    void setTimezone(int timezone);
    
    int syncTime();
    
    void setAlarm(int hour, int minute, int period);
    void setTimer(int hours, int minutes);
    void deleteAlarm();
    bool alarmSet();
    
    time_t getTime();
    int getTimezone();
    

private:
    int timezone;
    bool aSet;
    Ticker alarmTicker;
    Thread *alarmThread;
    
    void signalAlarm();
};
