#if defined(TARGET_NUCLEO_F303K8)

#define MODSERIAL_IRQ_REG ((USART_TypeDef*)_base)->CR1
/**
 * TCIE probably isn't the optimal definition (since it waits for transmission
 * complete before firing, as opposed to TXEIE which fires as soon as the buffer
 * is empty and able to accept another frame to transmit), but this is what
 * STM32F3's serial_api.c expects (and breaks if using TXEIE).
 * But if serial_api.c changes to TXEIE this (probably) will also need to be
 * updated.
 */
#define DISABLE_TX_IRQ MODSERIAL_IRQ_REG &= ~USART_CR1_TCIE
#define DISABLE_RX_IRQ MODSERIAL_IRQ_REG &= ~USART_CR1_RXNEIE
#define ENABLE_TX_IRQ MODSERIAL_IRQ_REG |= USART_CR1_TCIE
#define ENABLE_RX_IRQ MODSERIAL_IRQ_REG |= USART_CR1_RXNEIE

#define MODSERIAL_READ_REG ((USART_TypeDef*)_base)->RDR
#define MODSERIAL_WRITE_REG ((USART_TypeDef*)_base)->TDR
#define MODSERIAL_READABLE ((((USART_TypeDef*)_base)->ISR & USART_ISR_RXNE) != 0)
#define MODSERIAL_WRITABLE ((((USART_TypeDef*)_base)->ISR & USART_ISR_TXE) != 0)

#define RESET_TX_FIFO while(0 == 1)
#define RESET_RX_FIFO while(MODSERIAL_READABLE) char dummy = MODSERIAL_READ_REG

#define RX_IRQ_ENABLED ((MODSERIAL_IRQ_REG & USART_CR1_RXNEIE) != 0)
#define TX_IRQ_ENABLED ((MODSERIAL_IRQ_REG & USART_CR1_TCIE) != 0)

#endif
