#include "mbed.h"
#include "TextLCD.h"

DigitalOut led1(LED1);
Serial pc(SERIAL_TX, SERIAL_RX); 
AnalogIn button(A0);    // Init button (SELECT, LEFT, UP, DOWN, RIGHT)
TextLCD lcd(D8, D9, D4, D5, D6, D7); // LCD (RS, E, D4, D5, D6, D7);
PwmOut backlight(D10);  // Backlight LCD

int main()
{    
    // Set backlight period and duty cycle 
    backlight.period(0.002);
    backlight = 1;
    
    lcd.cls();                      // Clear LCD
    lcd.locate(1,0);                // Set locate (1 row, 2 column)
    lcd.printf("LCD Key Shield");
        
    while(1) {
        lcd.cls();
        lcd.locate(1,0);
        lcd.printf("%f", button.read());
        wait(1);
        led1 = !led1;
    }
}
