#include "mbed.h"
#include "USBHostMouse.h"
#include "TextLCD.h"

DigitalOut led1(LED1);
Serial pc(SERIAL_TX, SERIAL_RX); 
AnalogIn button(A0);    // Init button (SELECT, LEFT, UP, DOWN, RIGHT)
// LCD (RS, E, D4, D5, D6, D7);
TextLCD lcd(D8, D9, D4, D5, D6, D7);
PwmOut backlight(D10);  // Backlight LCD

void onMouseEvent(uint8_t buttons, int8_t x, int8_t y, int8_t z)
{
    static int buttonState =  0;
    
    if (buttons != buttonState){
        buttonState = buttons;
        
        lcd.cls();                      // Clear LCD
        lcd.locate(1,0);                // Set locate (1 row, 2 column)
        printf("Buttons: %d, x: %d, y: %d, z: %d\r\n", buttons, x, y, z);
        lcd.printf("Buttons: %d", buttons);   
    }
}

void mouse_task(void const *)
{
    USBHostMouse mouse;

    printf("Mouse started\r\n");

    while(1) {

        // Try to connect a USB mouse
        while(!mouse.connect()) {
            Thread::wait(500);
        }

        // When connected, attach handler called on mouse event
        mouse.attachEvent(onMouseEvent);

        // Wait until the mouse is disconnected
        while(mouse.connected()) {
            Thread::wait(500);
        }

        printf("Mouse disconnected\r\n");
    }
}

int main()
{
    // Set backlight period and duty cycle 
    backlight.period(0.002);
    backlight = 1;
    
    
    lcd.cls();                      // Clear LCD
    lcd.locate(1,0);                // Set locate (1 row, 2 column)
    lcd.printf("LCD Key Shield");
    wait(1);
    
    
    Thread mouseTask(mouse_task, NULL, osPriorityNormal, 1024* 4);
    while(1) {
        led1 = !led1;
        Thread::wait(100);
    }
}
