#include "debugMonitor.h"
#include "main.h"


using namespace std;

debugMonitor::debugMonitor(PinName tx, PinName rx) : serial(tx, rx) {
  commando = "";    
}

uint8_t debugMonitor::debugMonitor_Init(void)
{
    serial.baud(115200);
    //serial.printf("debugMonitor_Init\n");
    printLine("debugMonitor_Init()");
    
    serial.attach(this, &debugMonitor::readLineCallback);
    
    return(0);
}

debugMonitor::~debugMonitor(void) {
};

/** Private Functions */

void debugMonitor::readLineCallback()
{
    char inputChar = serial.getc();
    
    if(commando == "test")
    {
        printLine("cmd was test");
    }
    
    commando += inputChar;
    
    if(inputChar == '\r')
    {
        commando = "";
        serial.putc('\n');
    }
    serial.putc(inputChar);
}

void debugMonitor::printLine(char *string_p)
{
    serial.printf(string_p);
    serial.printf("\r\n");   
}