#include "mbed.h"
#include "MbedJSONValue.h"
#include <string>

Ticker toggle_led_ticker;
Ticker sendStuffTicker;

DigitalOut led1(LED1);
DigitalOut led2(LED2);
Serial pc(SERIAL_TX, SERIAL_RX); 

void toggle_led() {
    led1 = !led1;
}

void sendStuff() {
    static int counter=0;
    pc.printf("some stuff %u\n", counter++);
}


void makeJson(){
    MbedJSONValue demo;
    std::string s;
 
    //fill the object
    demo["my_array"][0] = "demo_string";
    demo["my_array"][1] = 10;
    demo["my_boolean"] = false;
 
    //serialize it into a JSON string
    s = demo.serialize();
    pc.printf("json: %s\r\n", s.c_str());    
}

void parseJson(){
     MbedJSONValue demo;
 
    const  char * json = "{\"my_array\": [\"demo_string\", 10], \"my_boolean\": true}";
 
    //parse the previous string and fill the object demo
    parse(demo, json);
 
    std::string my_str;
    int my_int;
    bool my_bool;
 
    my_str = demo["my_array"][0].get<std::string>();
    my_int = demo["my_array"][1].get<int>();
    my_bool = demo["my_boolean"].get<bool>();
    
    pc.printf("my_str: %s\r\n", my_str.c_str());
    pc.printf("my_int: %d\r\n", my_int);
    pc.printf("my_bool: %s\r\n", my_bool ? "true" : "false");
}

int main() {
    pc.baud(115200);
    pc.printf("start main()\n\r");    
    
    makeJson();
    parseJson();
    
    toggle_led_ticker.attach(&toggle_led, 0.2);
    sendStuffTicker.attach(&sendStuff, 2);
    
    while (true) {
        // Do other things...

        wait(1);
    }
}