#include <mbed.h>
#include <string>
#include <cassert>

#include "MbedJSONValue/MbedJSONValue.h"
#include "communication.h"

Ticker toggle_led_ticker;
Ticker sendStuffTicker;
Ticker readStuffTicker;

DigitalOut led1(LED1);
DigitalOut led2(LED2);
Serial pc(SERIAL_TX, SERIAL_RX); 

void toggle_led() {
    led1 = !led1;
}

Command mCommand;
Type mType(3);
Conf mConf(31);
Status mStatus;
HeartBeat mHeartBeat;

void parseJson(char * json){

    MbedJSONValue receive;   
    parse(receive, json);
 
    switch(mCommand.get(receive)){
        case TYPE:{
            mType.sendFrame();   
            break;    
        }  
        case CONF:{
            mConf.setConfig(receive) ? mConf.sendAck() : mConf.sendAck();
            break;    
        }  
        case STATUS:{
            mStatus.t1 = 12;
            mStatus.sendFrame();    
        }
        default:{
            assert(0);
            break;
        }
    }
}

void sendStuff() {
    static float strom = 1.1;
    static int durchfluss = 1;
    static float temp = 22;
    static int pumpStatus = 0;
    
    mHeartBeat.sendFrame();
    
    strom += 1.3f;
    durchfluss += 1;
    temp += 1.34f;
    pumpStatus = !pumpStatus;
    
}

int main() {
    pc.baud(115200);   
    
    pc.printf("main start\n\r");
    toggle_led_ticker.attach(&toggle_led, 0.05);
    sendStuffTicker.attach(&sendStuff, 1);
    
    char buffer[50];
    while (true) {

        // Do other things...
        if(pc.readable()){
            pc.scanf("%s", buffer);
            pc.printf("received :%s\n", buffer);
            parseJson(buffer);
        }
    }
}