#pragma once

#include "MbedJSONValue/MbedJSONValue.h"

enum Commands {TYPE, CONF, STATUS};

/** HeartBeat Class
 *
 * 
 */
class HeartBeat{
public:
    HeartBeat(){
        currentKey = "A";
        flowKey = "DF";
        tempKey = "T";
        pumpStatusKey = "PS";
    }
    void sendFrame(){
        MbedJSONValue send;
        send[currentKey] = 11.2;
        send[flowKey] = 33;
        send[tempKey] = 12.2f;
        send[pumpStatusKey] = 0;

        printf("%s\n", send.serialize().c_str() );   
    }
private:
  std::string currentKey;
  std::string flowKey;
  std::string tempKey;
  std::string pumpStatusKey;
};

/** Type Class
*
*
*/
class Type{
public:
    Type(int actId=1) {
      idKey = "ID"; 
      id = actId; 
      typeKey = "TYPE"; 
      type = "DC";
    }
    
    /**
    * Set new id
    * @param newId new id of the device
    */
    void setId(int newId){
        id=newId;
    }
    void sendFrame(void){
        MbedJSONValue send;
        send[idKey] = id;
        send[typeKey] = type;
        printf("%s\n", send.serialize().c_str() );   
    }
private:
    std::string idKey;
    int id;
    std::string typeKey;
    std::string type;
};

/** Conf Class
*
*
*/
class Conf{
public:
    Conf(int newTemperature=20){
        responseKey = "RSP";     
        tempKey = "T";
        temperature = newTemperature;
    }  
    
    /**
    * Set the configs
    * @param receive received json data
    * @returns status of the setConfig
    */
    bool setConfig(MbedJSONValue receive){
        temperature = receive[tempKey].get<int>();
        if(temperature > 50){
            temperature=50;
            return false;
        }
        else if(temperature < -20){
            temperature = -20;
            return false;
        }
        else{
            return true;
        }
    }

    int getTemparature(void){
        return temperature;
    }
    void sendAck(void){
        MbedJSONValue send;
        send[responseKey] = "OK";
        printf("%s\n", send.serialize().c_str() );   
    }
private:
    int temperature;
    std::string responseKey;
    std::string tempKey;
};

/** Status Class
*
*
*/
class Status{
public:
    /** Constructor, set the keys
     * @code
        n1Key[0] = "N1.1";
        n1Key[1] = "N1.2";
        n1Key[2] = "N1.3";
        n1Key[3] = "N1.4";
        n2Key    = "N2";
        n3Key    = "N3";
        t1Key    = "T1";
        hsKey    = "HS";
        statusKey = "STATUS";
     * @endcode
    */
    Status(){
        n1Key[0] = "N1.1";
        n1Key[1] = "N1.2";
        n1Key[2] = "N1.3";
        n1Key[3] = "N1.4";
        n2Key    = "N2";
        n3Key    = "N3";
        t1Key    = "T1";
        hsKey    = "HS";
        statusKey = "STATUS";
    }
    void sendFrame(){
        MbedJSONValue send;
        send[n1Key[0]] = n1[0];
        send[n1Key[1]] = n1[1];
        send[n1Key[2]] = n1[2];
        send[n1Key[3]] = n1[3];
        send[t1Key] = t1;
        send[hsKey] = hs;
        send[statusKey] = status;
        printf("%s\n", send.serialize().c_str() );   
    
    }
    int n1[4];
    int t1;
    int hs;
    int status;
    
private:
    std::string n1Key[4]; 
    std::string n2Key;
    std::string n3Key;
    std::string t1Key;
    std::string hsKey;
    std::string statusKey;
};

/** Command Class
*
*
*/
class Command{
public:
    Command(){
        cmdKey = "CMD";
    }
    Commands get(MbedJSONValue receive){
        std::string cmd = receive[cmdKey].get<std::string>();

        if(cmd == std::string("TYPE") ){       
            return TYPE;      
        }
        else if(cmd ==  std::string("CONF") ){
           return CONF;
        }
        else if(cmd == std::string("STATUS")) {
            return STATUS;
        }
        else{
            assert(0);    
            return TYPE;
        }
    }  
private:
    std::string cmdKey;
};