#include "mbed.h"
#include "USBHostMouse.h"

DigitalOut led1(LED1);

void onMouseEvent(uint8_t buttons, int8_t x, int8_t y, int8_t z)
{
    printf("Buttons: %d, x: %d, y: %d, z: %d\r\n", buttons, x, y, z);
}

void mouse_task(void const *)
{
    USBHostMouse mouse;

    printf("Mouse started\r\n");

    while(1) {

        // Try to connect a USB mouse
        while(!mouse.connect()) {
            Thread::wait(500);
        }

        // When connected, attach handler called on mouse event
        mouse.attachEvent(onMouseEvent);

        // Wait until the mouse is disconnected
        while(mouse.connected()) {
            Thread::wait(500);
        }

        printf("Mouse disconnected\r\n");
    }
}

int main()
{
    Thread mouseTask(mouse_task, NULL, osPriorityNormal, 1024* 4);
    while(1) {
        led1 = !led1;
        Thread::wait(500);
    }
}
