#include "inc/massStorage.h"
#include "rtos.h"
#include "USBHostMSD.h"
#include "inc/config.h"
#include <string>

void massStorage_task(void const *){
    bool readConfigs = false;
    USBHostMSD msd("usb");
    int i = 0;
    
    while(1) {
        
        // try to connect a MSD device
        while(!msd.connect()) {
            Thread::wait(500);
        }
        
        // in a loop, append a file
        // if the device is disconnected, we try to connect it again
        while(1) {
            
            if(!readConfigs){
                // read file
                FILE *fp = fopen("/usb/config.txt", "r");            
                if (fp != NULL){
                    printf("===> found config\r\n");
                    
                    std::string pause{""};
                    std::string cycles{""};
                                        
                    while(1) {
                        char c = fgetc(fp);
                        if( feof(fp) || c == '\n') { 
                            break ;
                        }
                        if(c != '\n' && c != '\r'){
                            pause += c;
                        }
                    }
                    while(1) {
                        char c = fgetc(fp);
                        if( feof(fp) || c == '\n' ){
                            break;
                        }
                        if(c != '\n' && c != '\r'){
                            cycles += c;
                        }
                    }                    
                    fclose (fp);               
                    setPause(pause);
                    setCycles(cycles);
                    printf("\r\n===> read the configs %s %s \r\n", pause.c_str(), cycles.c_str() );
                    readConfigs = true;                       
                }
                else{
                    printf("fp == NULL\r\n");    
                }
            }
            else{        
                // append a file
                FILE *fp = fopen("/usb/day.log", "a");
            
                if (fp != NULL) {
                    fprintf(fp, "log entry nr: %d!\r\n", i++);
                    printf("writing to logfile!\r\n");
                    fclose(fp);
                } else {
                    printf("FILE == NULL\r\n");
                }            
            }
            
            // if device disconnected, try to connect again
            if (!msd.connected()){
                readConfigs = false;
                break;
            }
            
            Thread::wait(10000);
        }
    }
}