#include "mbed.h"
#include "USBHostKeyboard.h"
#include "inc/display.h"

AnalogIn button(A0);    // Init button (SELECT, LEFT, UP, DOWN, RIGHT)

uint8_t lastKey;

void onKey(uint8_t key) {
    lastKey = key;
    displayKey(key);
    printf("key:%c\n\r", key);
}


void keyboard_task(void const *) {
    
    USBHostKeyboard keyboard;
    
    while(1) {
        // try to connect a USB keyboard
        while(!keyboard.connect())
            Thread::wait(500);

        printLine("connected",0);    
        // when connected, attach handler called on keyboard event
        keyboard.attach(onKey);
        
        // wait until the keyboard is disconnected
        while(keyboard.connected())
            Thread::wait(500);
        printLine("disconnected",0);
    }
}

void inputInit(void) {
    Thread keyboardTask(keyboard_task, NULL, osPriorityNormal, 256 * 4);
    printf("keyboard input thread created\n\r");
    while(1) {
        Thread::wait(500);
    }
}

uint8_t getKey(void){
    return lastKey;
}