#include "inc/display.h"

#include "TextLCD.h"
#include "mbed_assert.h"
#include <string>

TextLCD lcd(D8, D9, D4, D5, D6, D7);    // LCD (RS, E, D4, D5, D6, D7);
PwmOut backlight(D10);                  // Backlight LCD

/*  
     ------> x
   | (0,0)
   |             (15,1)   
   v y
*/




void setCursor(uint8_t x, uint8_t y){
    MBED_ASSERT(x <= 15);
    MBED_ASSERT(y <= 1);
}

void setLine(uint8_t y){
    MBED_ASSERT( y <= 1 );
    lcd.locate(0,y); 
}

void printLine(std::string text){
    MBED_ASSERT(text.size()<=16);
    lcd.printf(text.c_str());
}

void printLine(std::string text, uint8_t line){
    MBED_ASSERT(text.size()<=16);
    MBED_ASSERT(line <= 1);
    lcd.cls();       // Clear LCD
    lcd.locate(0,line); /* x/y */
    lcd.printf(text.c_str());
}

void displayInit(void){
    // Set backlight period and duty cycle 
    backlight.period(0.002);
    backlight = 1;
    lcd.cls();       // Clear LCD
    lcd.locate(0,FIRST_LINE); /* x/y */
    lcd.printf("testBoard");      
}

void displayKey(char key){
    lcd.cls();       // Clear LCD
    lcd.locate(0,FIRST_LINE); /* x/y */
    lcd.printf("%c", key);
}

void displayScreen(uint8_t nr){
    switch(nr){
        case 0:
        {
            lcd.cls();      
            setLine(FIRST_LINE);
            printLine("keyboard det.");
            break;
        }
        case 1:
        {
            lcd.cls();
            setLine(SECOND_LINE);
            printLine("buttons detected");
            break;
        }
    }
}