#include "mbed.h"
#include "rtos.h"
#include "inc/server.h"
#include "inc/massStorage.h"
#include "inc/config.h"

#include <string>

DigitalOut led1(LED1);
Serial pc(SERIAL_TX, SERIAL_RX); 

const int TASK_PROGRAMM_DELAY_MS = 4000;
const int TASK_LED_DELAY_MS = 100;

void program_task(void const *){
    while(1){
        Thread::wait(TASK_PROGRAMM_DELAY_MS);
        printf("prgramm running\r\n");
    }    
}

void led_task(void const *) {
    while(1){
        led1 = !led1;
        Thread::wait(TASK_LED_DELAY_MS);
    }    
}

int main()
{           
    pc.baud(115200);
    pc.printf("start main()\n\r");    

    Thread msdTask(massStorage_task, NULL, osPriorityNormal, 1024 * 4);
    Thread ledTask(led_task, NULL, osPriorityNormal, 1024 * 4);
    Thread programTask(program_task, NULL, osPriorityNormal, 1024 * 4);
    Thread serverTask(server_task, NULL, osPriorityNormal, 1024 * 4);
    
    while(1) {
        wait(0.5);    
    }
}
