

//Test of cheap 13.56 Mhz RFID-RC522 module from eBay
//This code is based on Martin Olejar's MFRC522 library. Minimal changes
//Adapted for Nucleo STM32 F401RE. Should work on other Nucleos too

//Connect as follows:
//RFID pins        ->  Nucleo header CN5 (Arduino-compatible header)
//----------------------------------------
//RFID IRQ=pin5    ->   Not used. Leave open
//RFID MISO=pin4   ->   Nucleo SPI_MISO=PA_6=D12
//RFID MOSI=pin3   ->   Nucleo SPI_MOSI=PA_7=D11
//RFID SCK=pin2    ->   Nucleo SPI_SCK =PA_5=D13
//RFID SDA=pin1    ->   Nucleo SPI_CS  =PB_6=D10
//RFID RST=pin7    ->   Nucleo         =PA_9=D9
//3.3V and Gnd to the respective pins

#include "mbed.h"
#include "MFRC522.h"

#define VERSION 1

//Serial connection to PC for output
Serial pc(USBTX, USBRX);
DigitalIn userButton(USER_BUTTON);





int main(void)
{
    pc.baud(115200);
    pc.printf("starting...\n");
    
    while(1){
     
        if(userButton == 0){
            printf(">>> start reading <<<\n");
            
            MFRC522 RfChip(SPI_MOSI, SPI_MISO, SPI_SCK, SPI_CS, D8);
            
            /** a test for static asserts */
            MBED_STATIC_ASSERT(VERSION < 5, "Version to high");
            
            RfChip.PCD_Init();
               
            while (userButton == 0) {            
           
                if ( RfChip.PICC_IsNewCardPresent()) {
                    if (RfChip.PICC_ReadCardSerial()) {
    
                        pc.printf("Card Reader 1: ");
                        for (uint8_t i = 0; i < RfChip.uid.size; i++) {
                            pc.printf(" %X02", RfChip.uid.uidByte[i]);
                        }
                        pc.printf("\n");
                        
                        printf("PICC Type: %s \n", 
                            RfChip.PICC_GetTypeName(RfChip.PICC_GetType(RfChip.uid.sak)));
                    }            
                }
            }
            
            printf(">>> end reading <<<\n");   
        }
                    
        //MBED_ASSERT(userButton == 1);
    }
    

}
