#include "mbed.h"
#include "main.h"
#include <CR95HF.h> 
 
DigitalOut ledMain(D13);
Serial pcDevice(USBTX, USBRX);

Thread thread;
 
/**
 * @brief thread for nfc stuff
 */
void nfc_thread()
{
    CR95HF nfcDevice(D8,D2);
    nfcDevice.Init();
    
    while (true) {
        nfcDevice.ConfigManagerTagHunting();
        wait(0.5);
    }
}



int main()
{
  pcDevice.baud(115200);

  pcDevice.printf("--- Startup NFC Demo ---\r\n");

  thread.start(nfc_thread);

  while (true) {
    ledMain = !ledMain;
    wait(0.2);
  }
}
