#include "mtch112.h"
#include "main.h"

MTCH112::MTCH112(PinName sda, PinName scl, uint8_t addr) : m_i2c(sda, scl), m_addr(addr) {}

uint8_t MTCH112::MTCH112_Init(void)
{
    printf("MTCH112_Init\n");
    
    SetRegister(CONFIG_RESET_CALIB, CONFIG_RESET_CALIB_VALUE);
    wait(0.5);
    SetRegister(CONFIG_TIMEOUT_L, 0x03);
    wait(0.1);
    SetRegister(CONFIG_TIMEOUT_H, 0xff);
    wait(0.1);
    SetRegister(CONFIG_OUTCON, CONFIG_OUTCON_VALUE);
    wait(0.1);
    SetRegister(CONFIG_LPCON, SLEEP_16ms | CLK_16MHZ);
    wait(0.1);
    SetRegister(CONFIG_PROX_THRESH, CONFIG_PROX_THRESH_VALUE);
    wait(0.1);
    SetRegister(CONFIG_PRESS_THRESH, CONFIG_PRESS_THRESH_VALUE);
    wait(0.5);
    
    printf("CONFIG_OUTCON:0x%02x\n", CONFIG_OUTCON_VALUE);
    printf("CONFIG_PROX_THRESH:0x%02x\n", CONFIG_PROX_THRESH_VALUE);
    printf("CONFIG_PRESS_THRESH:0x%02x\n", CONFIG_PRESS_THRESH_VALUE);
    
    return(0);
}

MTCH112::~MTCH112(void)
{
    
};

uint8_t MTCH112::MTCH112_GetState(void)
{
    return(GetRegister(OUTPUT_STATE));   
}

/** Private Functions */

void MTCH112::SetRegister(uint8_t registerAddr, uint8_t data)
{
  char dataWrite[5];

  dataWrite[0] = WRITE_PROTECT_BYTE_H;
  dataWrite[1] = WRITE_PROTECT_BYTE_L;
  dataWrite[2] = registerAddr;
  dataWrite[3] = data;
  dataWrite[4] = WRITE_PROTECT_BYTE_H ^ WRITE_PROTECT_BYTE_L ^ registerAddr ^ data;

  m_i2c.write(m_addr, dataWrite, 5);
}

uint8_t MTCH112::GetRegister(uint8_t registerAddr)
{
  char dataWrite[1];
  char dataRead[1];

  dataWrite[0] = registerAddr;
  dataRead[0] = 0x00;

  m_i2c.write(m_addr, dataWrite, 1);
  m_i2c.read(m_addr, dataRead, 1);
  
  return(dataRead[0]);
}