/**
* @file LP55231.h
 * @brief Library for LP55231
 * Version for mbed 
 * Nicolas Duchoud 22/08/2018
 * 
 * 
 * In this file are the function prototypes in the LP55231 class
 * 
 * This code is beerware. If you see me (or any other SparkFun employee) at the
 * local pub, and you've found our code helpful, please buy us a round!
 * 
 * Distributed as-is; no warranty is given.
*/
#include "mbed.h"

#ifndef LP55231_h
#define LP55231_h 

#define REG_ENGINE_CNTRL1 (0x00) 
#define REG_MISC          (0x36) 

#define REG_D1_PWM        (0x16)  /* GREEN1 */
#define REG_D2_PWM        (0x17)  /* BLUE1  */
#define REG_D3_PWM        (0x18)  /* GREEN2 */
#define REG_D4_PWM        (0x19)  /* BLUE2  */
#define REG_D5_PWM        (0x1A)  /* GREEN3 */
#define REG_D6_PWM        (0x1B)  /* BLUE3  */
#define REG_D7_PWM        (0x1C)  /* RED1   */
#define REG_D8_PWM        (0x1D)  /* RED2   */
#define REG_D9_PWM        (0x1E)  /* RED3   */

/** 
 * led enums 
 */
enum LP55231_leds 
{ 
    /** led1 on board */
    LP55231_LED1 = 0, 
    /** led2 on board */
    LP55231_LED2,
    /** led3 on board */     
    LP55231_LED3,
};

/** 
  * struct led colors 
  */
struct LP55231_colors 
{
    /** color red */
    uint8_t red;
    /** color green */
    uint8_t green;
    /** color blue */
    uint8_t blue;
};

/** My LP55231 class.
 *
 * Example:
 * @code
 * #include "mbed.h"
 * #include <LP55231.h>
 *
 * LP55231 board(I2C_SDA, I2C_SCL, LP55231_I2C_ADDR<<1);
 * 
 * struct LP55231_colors color = {50,100,0}; 
 * 
 * if(board.LP55231_Init() != 0)
 * {
 *     printf("FAILED TO INITALIZE\n"); 
 * }; 
 *   
 * board.LP55231_SetLed(LP55231_LED1, color);
 *   
 * @endcode
 */
class LP55231
{
    public:
  
        /** 
        * constructor of LP55231
        * 
        * @param sda SDA pin
        * @param sdl SCL pin
        * @param addr (7 bit) address of the I2C peripheral 
        */
        LP55231(PinName sda, PinName scl, uint8_t addr);
        
        /** deconstructor */
        ~LP55231();
        
        /**
        * LP55231 Init
        * @returns 0 if ok 
        * @returns -1 on error*/
        */
        uint8_t LP55231_Init(void);
        
        /**
        * @param led led to set
        * @param color color to set
        */
        void LP55231_SetLed(LP55231_leds led, LP55231_colors color);
  
    private:
        /** i2c handler */
        I2C m_i2c;
        /** i2c addr */
        int m_addr;
        /**
        * @param registerAddr
        * @param data
        */
        void SetRegister(uint8_t registerAddr, uint8_t data);
    
};


#endif