/**
  * @file LP55231.cpp
  *
  */

#include "LP55231.h"
#include "main.h"

LP55231::LP55231(PinName sda, PinName scl, uint8_t addr) : m_i2c(sda, scl), m_addr(addr) {}

uint8_t LP55231::LP55231_Init(void){
  
  SetRegister(REG_ENGINE_CNTRL1, 0x40);
  SetRegister(REG_MISC, 0x53);

  return 0;
}

LP55231::~LP55231(void) {
};


void LP55231::LP55231_SetLed(LP55231_leds led, LP55231_colors color)
{
    switch(led)
    {
        case LP55231_LED1:
        {
            SetRegister(REG_D7_PWM, color.red); /* RED1   */
            SetRegister(REG_D1_PWM, color.green); /* GREEN1 */
            SetRegister(REG_D2_PWM, color.blue); /* BLUE1  */   
            break;    
        }   
        case LP55231_LED2:
        {
            SetRegister(REG_D8_PWM, color.red); /* RED2   */
            SetRegister(REG_D3_PWM, color.green); /* GREEN2 */
            SetRegister(REG_D4_PWM, color.blue); /* BLUE2  */
            break;
        }
        case LP55231_LED3:
        {
            SetRegister(REG_D9_PWM, color.red); /* RED3   */
            SetRegister(REG_D5_PWM, color.green); /* GREEN3 */
            SetRegister(REG_D6_PWM, color.blue); /* BLUE3  */
            break;          
        }
        default:
        {
            ASSERT(0);
            break;
        }
    }
}

// --- Private Functions --- //

void LP55231::SetRegister(uint8_t registerAddr, uint8_t data)
{
    char data_write[2];
    data_write[0] = registerAddr;
    data_write[1] = data;
    m_i2c.write(m_addr, data_write, 2); 
}