/**
* @file CR95HF.h
* @brief Driver for CR95HF
*
*/
#include <mbed.h>


/**
* My CR95HF class.
* 
* This code works for ISO 15693 Tags (only!)
* More ISOs will soon be added
*
* There is a STM32Cube X-Cube-NFC Example on st.com site for all ISOs and Types 
* https://www.st.com/content/st_com/en/products/embedded-software/st25-nfc-rfid-software/x-cube-nfc3.html
* (Warnings: the st project is a lot of pain to work with!)
* 
* Example:
* @code
* #include <CR95HF.h>
* 
* CR95HF nfcChip(UART_TX, UART_RX);
*
* nfcChip.Init();
* 
* while(true) {
*   nfcChip.ConfigManagerTagHunting();
* }
*
* @endcode
*/
class CR95HF
{
    public:
        /** Constructor */
        CR95HF(PinName tx, PinName rx);
        ~CR95HF();
        uint8_t Init();
        uint8_t ConfigManagerTagHunting();
    
    private:
        Serial  nfcDevice;
        void    nfcWrite(uint8_t cmd[], uint8_t len);
        bool    rxMsgComplete;
        uint8_t rxData[256];
        uint8_t rxBufPos;
        uint8_t blub;
        uint8_t len;
        void    rxCallbackNFC();
};
