#include <CR95HF.h>

DigitalOut InterfacePin(D9);

DigitalOut led1(D7);
DigitalOut led2(D6);
DigitalOut led3(D5);
DigitalOut led4(D4);

CR95HF::CR95HF(PinName tx, PinName rx) : nfcDevice(tx,rx) 
{
    InterfacePin = false;
}

CR95HF::~CR95HF() {};
        
uint8_t CR95HF::Init()
{   
    uint8_t commandInfo[] = {0x01, 0x00};
    uint8_t commandSetProtocoll[] = {0x02, 0x02, 0x01, 0x05};
    
    printf("CR95HF_Init\r\n");
    
    nfcDevice.baud(57600);

    wait(1);
    nfcWrite(commandInfo, 2);
    wait(1);
    nfcWrite(commandSetProtocoll, 4);
    wait(1);
    nfcDevice.attach(this, &CR95HF::rxCallbackNFC, Serial::RxIrq);
    return(0);       
}

uint8_t CR95HF::ConfigManagerTagHunting()
{
    uint8_t returnValue = false;
    uint8_t detectCard[] = {0x04, 0x03, 0x26, 0x01, 0x00};

    static uint16_t counter=0;

    rxBufPos = 0;
    rxMsgComplete = false;

    nfcWrite(detectCard, 5);
    
    wait(0.2);

    if(blub == 0x80) {
      led3 = true;
      led4 = false;
      printf("tag deteced UID (cnt %u):", counter++);
      for(int pos=7;pos>=0;pos--)
      {
        printf("%02x", rxData[pos]);
      }
      printf("\r\n");
    }
    else
    {
      led4 = true;
      led3 = false;
      printf("no tag (%02x)\r\n", blub);
    }
    return(returnValue);
}

/** private functions */

void CR95HF::nfcWrite(uint8_t cmd[], uint8_t len)
{
  for(int pos=0; pos<len;pos++)
  {
    nfcDevice.putc(cmd[pos]);
  }
}

void CR95HF::rxCallbackNFC()
{
  uint8_t character;

  while(nfcDevice.readable()) {
    character = nfcDevice.getc();

    if(rxBufPos == 0) {
      blub = character;
    }
    else if(rxBufPos == 1) {
      len = character;
    }
    else if(rxBufPos == 2) {

    }
    else if(rxBufPos == 3) {

    }
    else {
      rxData[rxBufPos-4] = character;
    }
    rxBufPos++;

    if(rxBufPos >= len) {
      rxMsgComplete = true;
    }

  }
}
