#include "mbed.h"
#include "LSM9DS0.h"
#include "PinDetect.h"

// SDO_XM and SDO_G are pulled up, so our addresses are:
#define LSM9DS0_XM_ADDR  0x1D // Would be 0x1E if SDO_XM is LOW
#define LSM9DS0_G_ADDR   0x6B // Would be 0x6A if SDO_G is LOW

LSM9DS0 imu(p9, p10, LSM9DS0_G_ADDR, LSM9DS0_XM_ADDR); // IMU
DigitalIn L(p21); // Left flipper
DigitalIn R(p22); // Right flipper
Serial pc(USBTX, USBRX); // Serial read out
AnalogIn plunger(p20); // Slide potentiometer
DigitalOut led1(LED1); //left
DigitalOut led2(LED2); //right
DigitalOut led3(LED3); //coin
AnalogIn coin(p19); // IR Sensor

//variables changed by callback functions to be printed to serial
int coins=0;
int volatile left=0;
int volatile right=0;
int  plungers=0;
void L_hit_callback (void)
{
    left=1;
}

void R_hit_callback (void)
{
    right=1;
}

int main()
{
    // Use the begin() function to initialize the LSM9DS0 library.
    // You can either call it with no parameters (the easy way):
    uint16_t status = imu.begin();

    //Make sure communication is working (DEBUG)
    pc.printf("LSM9DS0 WHO_AM_I's returned: 0x%X\n", status);
    pc.printf("Should be 0x49D4\n\n");
    while(1) {
        //Setup default values
        plungers=0;
        led1=L;
        led2=R;
        left=L;
        right=R;

        // imu readings
        imu.readAccel();
        float heading = imu.calcHeading();

        //detect if coin was inserted
        if (coin>0.35f) { 
            led3=1;
            coins=1;
        } else {
            led3=0;
            coins=0;
        }
        // which speed to launch ball at
        if (plunger<0.25f) {
            plungers=1;
        } else if(plunger<0.5f) {
            plungers=2;
        } else if(plunger<0.75f) {
            plungers=3;
        } else if(plunger<2.0f) {
            plungers=4;
        }
        // Write to serial - order matters (left, right coin, plunger, imu)
        pc.printf("%i,%i,%i,%i,%.1f\r\n",left,right,coins,plungers, imu.ay);
        wait(0.20);
    }
}
