#include "mbed.h"
#include "uLCD_4DGL.h"
#include "rtos.h"
#include "PinDetect.h"
//Joystick Inputs
PinDetect up(p17);
PinDetect down(p13);
PinDetect left(p15);
PinDetect right(p14);
PinDetect c(p16);
//RTOS Mutex
Mutex DAmu;
//uLCD
uLCD_4DGL uLCD(p9,p10,p11); // serial tx, serial rx, reset pin;

//SCREENSAVER VARIABLES
int volatile counter=0; //GLOBAL COUNTER VARIABLE FOR SCREENSAVER MODE
int color[] = {RED,BLUE,GREEN}; //color to be written to screen
//int save[128*128];       //Vector to save current screen

// SCREENSAVER FUNCTIONS
/*
void savescreen()
{
    for(int i=0; i<(128)&&counter!=0; i++) {
        for(int k=0; (k<128)&&counter!=0; k++) {
            save[k+i*128]==uLCD.read_pixel(k,i);     //save current screen to memory
        }
    }
}
void recoverscreen()
{
    for(int i=0; i<(128)&&counter!=0; i++) {
        for(int k=0; (k<128)&&counter!=0; k++) {
                DAmu.lock();                           //Use Mutex to decide which function writes to screen
                uLCD.pixel(k,i,save[i+k*128]);       //Randomizes color to be written to screen
                DAmu.unlock();
        }
    }
}
*/
void screensaver(void const *args)
{
   // savescreen();                                      //store current screen before entering screensaver mode
    while(counter!=0) {
        uLCD.cls();
        for(int i=0; i<(128)&&counter!=0; i++) {
            for(int k=0; (k<128)&&counter!=0; k++) {
                DAmu.lock();                           //Use Mutex to decide which function writes to screen
                uLCD.pixel(k,i,color[rand()%3]);       //Randomizes color to be written to screen
                DAmu.unlock();
            }
        }
        uLCD.cls();
     //   recoverscreen();                               //Call function to restore screen when exiting screensaver mode
        Thread::wait(1000);
    }
}


//Variables and function calls for sample program (NOT REQUIRED)
int volatile count=0;
int volatile dy=64;
int volatile dx=64;

void up_hit_callback (void)
{
    dy--;
    count =1;
    counter=0;
    Thread::wait(1);
}
void down_hit_callback (void)
{
    dy++;
    count =1;
    counter=0;
    Thread::wait(1);
}
void left_hit_callback (void)
{
    dx--;
    count =1;
    counter=0;
    Thread::wait(1);
}
void right_hit_callback (void)
{
    dx++;
    count =1;
    counter=0;
    Thread::wait(1);
}

void c_hit_callback (void)
{
    count = 1;
    counter=0;
    Thread::wait(1);
}


int main()
{
    //Setup Pushbuttons or Joystick
    up.mode(PullDown);
    down.mode(PullDown);
    left.mode(PullDown);
    right.mode(PullDown);
    c.mode(PullDown);

    up.setSampleFrequency();
    down.setSampleFrequency();
    left.setSampleFrequency();
    right.setSampleFrequency();
    c.setSampleFrequency();

    //JoyStick or Pushbutton functional fall interrupts set up
    up.attach_deasserted(&up_hit_callback);
    down.attach_deasserted(&down_hit_callback);
    left.attach_deasserted(&left_hit_callback);
    right.attach_deasserted(&right_hit_callback);
    c.attach_deasserted(&c_hit_callback);

    //initialize screen
    uLCD.baudrate(100000);
    DAmu.lock();
    uLCD.background_color(BLACK);
    uLCD.cls();
    DAmu.unlock();

    while(1) {
        DAmu.lock();
        if(counter==500) {            //screensaver mode conditional and desired wait time counter
            DAmu.unlock();
            screensaver(0);
            counter++;
        } else {                      // Desired code for MBED uLCD program (Not screensaver mode)
            if (count==1) {
                uLCD.cls();
                DAmu.unlock();
                count=0;
            } else {
                DAmu.lock();
                uLCD.filled_rectangle(dx+2,dy+2 ,dx-2, dy-2, WHITE);
                DAmu.unlock();
            }
            counter++;
        }
        Thread::wait(1);
    }
}
