/* Class SSEL_spi, Copyright 2014, David T. Mort (http://mbed.org/users/dtmort/)

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

     http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
*/
#include "SSEL_spi.h"
#include "mbed.h"

SSEL_spi::SSEL_spi(uint32_t frame, int mode){
    //hardwire SPI sclk to p30 so Counter2 can trigger p8 SSEL from serial clock counts
    //Setup Timer/Counter2 ********************************************************************************
     LPC_SC->PCONP |=       0x00400000; //Timer/COUNTER2 turn power on bit 22, Table 46
     LPC_PINCON->PINSEL0 |= 0x00003300; //Timer/COUNTER2: (9:8)CAP2.0 on p30, (13:12)MAT2.0 on p8(SSEL), Table 79
     switch (mode){
        case 1:
        case 2:
            LPC_TIM2->CTCR= 2;          //increment on falling edge of CAP2.0 input, Table 428
        break;
        case 0:
        case 3:
            LPC_TIM2->CTCR= 1;          //increment on rising edge of CAP2.0 input, Table 428
     }
     LPC_TIM2->MCR  =       3;          //reset TC on match to MR0 (bit 1) & interrupt (bit 0), Table 429
     LPC_TIM2->EMR  =       48;         //set bits 5:4 for toggle function, clear bit 0 MAT2.0(SSEL), Table 431/432
     
     NVIC_EnableIRQ(TIMER2_IRQn);       //this method enables timer2 interrupt at run time
     
     LPC_TIM2->TCR  =       3UL;        //1:0 reset TC/PC & enable counter, clear bit 1 to begin counting, Table 427    
     LPC_TIM2->MR0  =       frame;      //clock bit counter load, see 21.6.7
     LPC_TIM2->TCR &=      ~2UL;        //clear bit 1 to enable counting
}

void SSEL_spi::active(bool cs){
     LPC_TIM2->EMR =        48+cs;      //set or clear bit 0 of MAT2.0(SSEL) pin 8 output, Table 431/432
}     

    // ISR routine ****************************************************************************************
extern "C" void TIMER2_IRQHandler (void){
    if((LPC_TIM2->IR & 0x01)==0x01){    //if MR0 interrupt, proceed, Table 426
        LPC_TIM2->IR  =      1UL;       //clear MR0 interrupt flag by writing 1, writing 0 has no effect
        LPC_TIM2->EMR ^=     1UL;       //toggle bit:0 to reset SSEL back to active state, Table 431
    }
}
