#include "mbed.h"
#include "C12832.h"  /* for the LCD */
#include <string>

/* 
This program allows the device to receive notifications from the MQTT server
*/

/* Global Variables */
DigitalOut myled(LED_GREEN);
Serial pc(USBTX, USBRX); /* serial port to PC */
C12832 shld_lcd (D11, D13, D12, D7, D10);   /* LCD */


PwmOut spk (D6);

//connections for RGB LED
DigitalOut r_led (LED1);    //Red indicates temp read off
DigitalOut g_led (LED2);    //green indicates temp read on and printing
DigitalOut b_led (LED3);    //Blue should only be on when first turned on before any human interaction  


    InterruptIn sw2_int (PTC6); //Button interrupts to be used to stop/resume temperature print out          
    InterruptIn sw3_int (PTA4); 
    
    static volatile int sw2_trig;   //allows for randon access, changing value
    static volatile int sw3_trig;

 
int main() {
    
    pc.baud (38400); 
    
    shld_lcd.printf("Device ready \r\n");
    wait(2);
    shld_lcd.cls(); // clear the display
    
    while(1) {

        if(pc.readable()) 
        {
            char c;
            char buffer[128];

            
            int bufSize = sizeof(buffer);
            
            pc.gets(buffer, 30);
            

            shld_lcd.printf("'%s'\n", buffer); //Prints when data is received i.e. notification  

            if (bufSize > 2)
            {
                /* speaker code taken from https://developer.mbed.org/users/4180_1/notebook/using-a-speaker-for-audio-output/ */
                // two tone police siren effect -  two periods or two frequencies
                // increase volume - by changing the PWM duty cycle
                int i = 0;
                for (i=0; i<26;) 
                {
                    spk.period(1.0/969.0);
                    spk = float(i)/50.0;
                    wait(.5);
                    spk.period(1.0/800.0);
                    wait(.5); 
                    i+=2;
                }
                
                spk = 0; //stops speaker
                wait(2);
                shld_lcd.cls(); // clear the display
                
                /* green */
                r_led = 2; 
                b_led = 2;
                g_led = 0;
                //wait(2.5);
            }
                /* green */
                r_led = 2; 
                b_led = 0;
                g_led = 2;
        }
    }
}
