/*This library will decode an MSF signal on a digital input pin and turn it 
into a timestamp.
Copyright (C) 2017 Duncan Wood

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/



#include "mbed.h"
class MSF_Time
{
public:
/* Start MSF_Time with this function
InputPin is the data coming from your reciever
 Polarity is 0 if your receiver output is high for no carrier
 polarity is 1 to invert this logic. */
 
 
MSF_Time(PinName InputPin, int polarity,int OffsetTuning =48000);

bool Valid(); // Is the time valid
time_t Read();

protected:
struct MSF_Data {
    int BCDYear;
    int BCDMonth;
    int DayOfWeek;
    int BCDTime;
    int SyncByte;  //This is sent and allows you to detect leap seconds
    int DUT;
    int BST;
};

struct MSF_Data MyData;    
struct tm Received_Time; // Normal data coming in
time_t Received_timestamp;  //Data converted to timestamp
unsigned int Time_Data_Duration; //Pulse length - The minute marker is 500ms
bool Time_Data_Sync;  // True when a 500ms pulse is detected denoting the start of a minute
Ticker Time_Data_Ticker;  // A 50ms clock used to clock in data
unsigned int Time_Data_Count;//  counts the 50ms for clocking in the data
void Time_Data_Strobe(); // When the ticker ticks do this
void Falling();
void Rising();
bool DataValid;
Timeout offset; // used to fine tune the seconds 50ms equals zero offset
InterruptIn Time_Data;
DigitalIn MyInput;
int Polarity;
int OffsetTuning;
Timer Time_Data_timer;
void LogicOne();
void LogicZero();
int ParityCheck(unsigned int CheckMe);
void ProcessData();
void IncrementSeconds();
void IncrementSecondsNow();
//int const OffsetTuning=48000; //in microseconds
bool debug;  //turn on off debugging noise
bool DV;

};