#include "mbed.h"
#include "stdio.h"
#include "string.h"
#include "stdlib.h"

//Tarea de pid controlado por blueetooth

Serial GSM(PTE0,PTE1);  //puertos del FRDM para el modem
Serial pc(USBTX,USBRX); //puertos del PC

float pid,o,ai,ad,ap,med,err;
float err_v;
float KPNII,KDNII;

char buffer[5];// TAMAÑO DEL BUFER
char bufferB[5];
char KPC[4],KDC[4];
char KPCII[4],KDCII[4];
char *cadena = "";
char r[]="";

Timer t;   //VALOR DEL TIEMPO
int count;
int i = 0;
int c=0;


DigitalOut LedRojo(LED1);
DigitalOut LedVerde(LED2);
DigitalOut LedAzul(LED3);


AnalogIn y(PTB3);//entrada analoga
AnalogOut u(PTE30); //salida analoga
PwmOut led(PTA13); // salida pwm




int readBuffer(char *buffer,int count)   //esta funcion lee un bufer de datos
{
    int i=0;
    t.start();    //CUENTA EL TIEMPO DE CONEXION E INICIA
    while(1) {
        while (pc.readable()) {
            char c = pc.getc();

            if (c == '\r' || c == '\n') c = '$';//si se envia fin de linea o de caracter inserta $
            buffer[i++] = c;//mete al bufer el caracter leido
            if(i > count)break;//sale del loop si ya detecto terminacion
        }
        if(i > count)break;
        if(t.read() > 1) {  //MAS DE UN SEGUNDO DE ESPERA SE SALE Y REINICA EL RELOJ Y SE SALE
            t.stop();
            t.reset();
            break;
        }
    }
    return 0;
}

int readBufferB(char *bufferB,int count)   //esta funcion lee un bufer de datos
{
    int i=0;
    t.start();    //CUENTA EL TIEMPO DE CONEXION E INICIA
    while(1) {
        while (GSM.readable()) {
            char c = GSM.getc();

            if (c == '\r' || c == '\n') c = '$';//si se envia fin de linea o de caracter inserta $
            bufferB[i++] = c;//mete al bufer el caracter leido
            if(i > count)break;//sale del loop si ya detecto terminacion
        }
        if(i > count)break;
        if(t.read() > 1) {  //MAS DE UN SEGUNDO DE ESPERA SE SALE Y REINICA EL RELOJ Y SE SALE
            t.stop();
            t.reset();
            break;
        }
    }
    return 0;
}

void cleanBuffer(char *buffer, int count)  //esta funcion limpia el bufer
{
    for(int i=0; i < count; i++) {
        buffer[i] = '\0';
    }
}

void cleanBufferB(char *bufferB, int count)  //esta funcion limpia el bufer
{
    for(int i=0; i < count; i++) {
        bufferB[i] = '\0';
    }
}


int main(void)
{
LL:
    LedVerde=1;
    LedRojo=1;
    LedAzul=1;
    LedVerde=0;
    wait(2);   //PRENDE EL LED VERDE POR 2 SEGUNDOS
    LedVerde=1;

    led.period(0.005f);      // 4 second period
    led.write(0.40f);      // 50% duty cycle, relative to period
    pc.printf("CONTROLADOR PID \n");
    pc.printf(" Escriba PC para comunicacion por pc \n");
    pc.printf(" Escriba BL para comunicacion por Bluetooth \n");

    {       

        int kpnum=0,kdnum=0,kinum=0,ok=0; // se inicializan las variables
        float spnum=0.0;
        while(1) {

            if (pc.readable()) {        // se leen los datos del pc.
                readBuffer(buffer,5);

                if(strncmp(buffer, "BL", 2) == 0) { // si se envia BL se utiliza blueetooth
                
                   // se muestra en un mensaje sal instrucciones
                    GSM.printf(" \n");
                    GSM.printf("\n CONTROLADOR PID (Bluetooth) \n");
                    GSM.printf("\n Ingrese el parametro a modificar KP , KD, KI, SP(SetPoint) ) \n" );
                    GSM.printf("\n Escriba M para mirar los parametros del PID \n");
                    GSM.printf("\n Escriba OK para Iniciar PID \n");
                    GSM.printf(" \n");

pc1:
                    ok=0;
                    if (GSM.readable()) {      // dependiendo del caracter que se envie, se ingresa a cada uno de los condicionales, se compara y se guarda el valor
                        readBufferB(bufferB,5);
                        LedRojo=0;

                        if (strncmp(bufferB, "KP", 2) == 0) {     //compara dos cadenas
                            GSM.printf("Ingrese valor para KP seguido de un caracter : \n");
                            GSM.scanf("%d", &kpnum); // el valor de guarda en la variables
                            GSM.printf(" \n");

                        }

                        if (strncmp(bufferB, "KD", 2) == 0) {      //compara dos cadenas
                            GSM.printf("ingrese valor de KD seguido de un caracter :\n");
                            GSM.scanf("%d", &kdnum); // guarda la variable
                            GSM.printf(" \n");

                        }

                        if (strncmp(bufferB, "KI", 2) == 0) {
                            GSM.printf("ingrese valor de KI seguido de un caracter : \n");
                            GSM.scanf("%d", &kinum);
                            GSM.printf(" \n");

                        }

                        if (strncmp(bufferB, "SP", 2) == 0) {
                            GSM.printf("ingrese valor de SetPoint entre [0 3.3]v seguido de un caracter : \n");
                            GSM.scanf("%f", &spnum);
                            GSM.printf(" \n");

                        }

                        if (strncmp(bufferB, "OK", 2) == 0) { // cuando se de ok inicial el controlador
                            ok=1;
                            GSM.printf("INICIA CONTROLADOR, PRESIONE F PARA REGRESAR AL MENU DEL PC\n");
                            GSM.printf(" \n");
                            wait(2);
                        }
                        if (strncmp(bufferB, "M", 1) == 0) { // M muestra los parametros que se ingresaron hasta el momento

                            GSM.printf("PARAMETROS \n");
                            GSM.printf(" \n");
                            GSM.printf("\n KP = %d \n", kpnum);
                            GSM.printf("\n KI = %d \n", kinum);
                            GSM.printf("\n KD = %d \n", kdnum);
                            GSM.printf("\n SP = %0.01f \n ", spnum);

                            GSM.printf("\n Para modificar escriba KP,KI,KD,SP \n"); // se dan nuevas instrucciones
                            GSM.printf("\n Escriba M para mirar los parametros del PID \n");
                            GSM.printf("\n Escriba OK para Iniciar PID \n");
                        }
                                                
                        if(ok==1) { // si se obtuvo la confirmacion empieza el controlador


                            cleanBufferB(bufferB,5); // se limpia el buffer
lop2:
                            LedRojo=1;
                            wait(1);
                            LedRojo=0;
                            med = y.read()*3.3;
                            err = (spnum-med);  //se calcula el error
                            ap = kpnum*err*0.01f;     //se calcula la accion proporcinal
                            ai =(kinum*err*0.01f)+ai;    //calculo de la integral del error
                            ad = kdnum*(err-err_v)*0.01f; //calculo de la accion derivativa
                            pid = (ap+ai+ad);

                            if(pid<=0) { // se verifica las condiciones max y min
                                pid=0;

                            }


                            if (pid > 3.3) {
                                pid=3.3;

                            }


                             // se muestran en pantalla los resultados
                            GSM.printf("ERROR=   %0.01f  ",err);
                            GSM.printf("    ");
                            GSM.printf("MEDICION=   %0.01f ",med);
                            GSM.printf("    ");
                            GSM.printf("SETPOINT= %0.01f  ",spnum);
                            GSM.printf("    ");
                            GSM.printf("PID=  %0.01f \r\n ",pid);


                            //Normalizacion de la salida
                            // se actualizan las variables *******************************************
                            err_v = err;
                            o = pid/3.3;
                            u.write(o);
                            //  se envia el valor pid a puerto analogico de salida (D/A) **************

                            //  se repite el ciclo

                            if (GSM.readable()) {
                                readBufferB(bufferB,5);
                                if (strncmp(bufferB, "F", 1) == 0) {   // si se envia una f se sale del ciclo y retoma al inicio                              

                                    ok=0;
                                    goto LL;
                                  
                                } else {
                                    wait_ms(100);
                                    goto lop2;
                                }
                            } else {
                                wait_ms(100);
                                goto lop2;
                            }

                        } // del if del ok

                    } //DATOS
                    goto pc1;



                }

                if (strncmp(buffer, "PC", 2) == 0) { // si recibe pc ingresa a dico modo

                    LedAzul=0;
                    // se dan las instrucciones
                    pc.printf(" \n");
                    pc.printf("CONTROLADOR PID (pc) \n");
                    pc.printf("Ingrese el parametro a modificar KP , KD, KI, SP(SetPoint) ) \n" );
                    pc.printf("Escriba M para mirar los parametros del PID \n");
                    pc.printf("Escriba OK para Iniciar PID \n");
                    pc.printf(" \n");
pc:
                    if (pc.readable()) {
                        readBuffer(buffer,5); // se lee la variable ingresada



                        if (strncmp(buffer, "KP", 2) == 0) {     //se compara dos cadenas, la ingresada con la variable
                            pc.printf("Ingrese valor para KP: \n"); // se pide el valor
                            pc.scanf("%d", &kpnum); // se guarda el valor
                            pc.printf(" \n");

                        }

                        if (strncmp(buffer, "KD", 2) == 0) {           // el 2 es la longitud
                            pc.printf("ingrese valor de KD:\n");
                            pc.scanf("%d", &kdnum);
                            pc.printf(" \n");

                        }

                        if (strncmp(buffer, "KI", 2) == 0) {
                            pc.printf("ingrese valor de KI: \n");
                            pc.scanf("%d", &kinum);
                            pc.printf(" \n");

                        }

                        if (strncmp(buffer, "SP", 2) == 0) {
                            pc.printf("ingrese valor de SetPoint entre [0 3.3]v \n");
                            pc.scanf("%f", &spnum);
                            pc.printf(" \n");

                        }

                        if (strncmp(buffer, "OK", 2) == 0) { // si se envia 0k inicia el controlador
                            ok=1;
                            pc.printf("INICIA CONTROLADOR, F PARA REGRESAR AL MENU \n");
                            pc.printf(" \n");
                            wait(2);
                        }
                        if (strncmp(buffer, "M", 1) == 0) { // m muestra los parametros configurados que van hasta el momento

                            pc.printf("PARAMETROS \n");
                            pc.printf(" \n");
                            pc.printf("KP = %d \n", kpnum);
                            pc.printf("KI = %d \n", kinum);
                            pc.printf("KD = %d \n", kdnum);
                            pc.printf("SP = %0.01f \n ", spnum);
                            pc.printf(" \n");
                            pc.printf("Para modificar escriba KP,KI,KD,SP \n");
                            pc.printf("Escriba M para mirar los parametros del PID \n");
                            pc.printf("Escriba OK para Iniciar PID \n");
                        }
                        
                        if(ok==1) { // inicia el controlador cuando se envia un ok

                            cleanBuffer(buffer,5); // se limpia el buffer
lop1:

                            LedAzul=1;
                            wait(1);
                            LedAzul=0;


                            med = y.read()*3.3;
                            err = (spnum-med);  //se calcula el error
                            ap = kpnum*err*0.01f;     //se calcula la accion proporcinal
                            ai =(kinum*err*0.01f)+ai;    //calculo de la integral del error
                            ad = kdnum*(err-err_v)*0.01f; //calculo de la accion derivativa
                            pid = (ap+ai+ad);


                            // se verifica que pid sea positivo **************************************
                            if(pid<=0) {
                                pid=0;

                            }

                            // se verifica que pid sea menor o igual la valor maximo *****************
                            if (pid > 3.3) {
                                pid=3.3;

                            }


               // se muestrar las variables mas importantes del control

                            pc.printf("ERROR=   %0.01f  ",err);
                            pc.printf("    ");
                            pc.printf("MEDICION=   %0.01f ",med);
                            pc.printf("    ");
                            pc.printf("SETPOINT= %0.01f  ",spnum);
                            pc.printf("    ");
                            pc.printf("PID=  %0.01f \r\n ",pid);


                            //Normalizacion de la salida
                            // se actualizan las variables *******************************************
                            err_v = err;
                            o = pid/3.3;
                            u.write(o);

                            if (pc.readable()) {
                                readBuffer(buffer,5);
                                if (strncmp(buffer, "F", 1) == 0) {                                  

                                    ok=0;
                                     goto LL;
                                    //goto pc;
                                    //cleanBufferB(bufferB,5);
                                } else {
                                    wait_ms(1000);
                                    goto lop1;
                                }
                            } else {
                                wait_ms(1000);
                                goto lop1;
                            }

                            //  se envia el valor pid a puerto analogico de salida (D/A) **************

                            //  se repite el ciclo
                            

                        } // DEL IF OK
                        goto pc;
                    } // del if DE LOS DATOS
                    goto pc;
                } //MODO PC

            }// DEL WHILE

            cleanBuffer(buffer,5);



        }

    }

}
