#include "LoRaWAN.h"

LoRaWAN::LoRaWAN() : serial_lora(UART_TX,UART_RX) {}
LoRaWAN::LoRaWAN(PinName USART_TX, PinName USART_RX) : serial_lora(USART_TX,USART_RX) {}

bool LoRaWAN::init(){
    serial_lora.baud(9600);
    if(!sendMessage(reboot)){
        return false;
    }
    wait(2);
    if(!sendMessage(appEUI)){
        return false;
    }
    wait(0.5);
    if(!sendMessage(appKEY)){
        return false;
    }
    wait(0.5);
    if(!sendMessage(join)){
        return false;
    }
    wait(4);
    return true;
}   
    
bool LoRaWAN::sendMessage(char *data_buf)
{
    serial_lora.printf("%s\r\n",data_buf);
    return true;
}

void LoRaWAN::recieveData(char *data_buf, int numchar)
{
    int count=0;
    if(numchar == 0) {
        numchar = sizeof(data_buf);
    }
    while(numchar!=count) {
        if(serial_lora.readable()) {
            *data_buf = serial_lora.getc();
            data_buf+=1;
            count++;
        }
    }
}


