#ifndef MBED_LoRaWAN_H
#define MBED_LoRaWAN_H

#include "mbed.h"

#define UART_RX            PD_2 
#define UART_TX            PC_12 

#define appEUI       "AT+APPEUI=70B3D57ED0029683"
#define appKEY       "AT+APPKEY=7383F39F198AF48F47406485AB28AF5D"
#define join         "AT+JOIN"
#define reboot       "AT+NRB"

class LoRaWAN {
    private:
        Serial serial_lora;
        
    public:
        /** Initialize object with default uart pins */
        LoRaWAN();
        
        /** Initialize object with specific uart pins */
        LoRaWAN(PinName USART_TX, PinName USART_RX);
        
        /** Boot up the communication and checks if acking */
        bool init();
        
        /** Send LoraWAN message */
        bool sendMessage(char *data_buf);
        
        /** recieve data from the LoRaWAN module */
        void recieveData(char *data_buf, int numchar);
        
        
};

#endif