#include "mbed.h"
#include "TCS34725.h"
#include "LoRaWAN.h"

InterruptIn button1(PG_0);
InterruptIn button2(PG_1);
Serial pc(USBTX, USBRX);
DigitalOut ledRED(PD_14);
DigitalOut ledGreen(PB_0);
DigitalOut ledBlue(PD_15);

TCS34725 colorSens(PB_9,PB_8);
LoRaWAN OCTA_LoRa(PC_12, PD_2);

double delay = 0.5; // 500 ms
uint16_t r,g,b,c;

void BTN1pressed()
{
    delay = 0.1; // 100 ms
    
}

void BTN1released()
{
    delay = 0.5; // 500 ms
}

void BTN2pressed()
{
    //Andere code nodig
    
}

void BTN2released()
{
    char data[50];
    char msg[25]= "AT+SENDB="; 
    sprintf(msg+9,  "%04X",  r);
    sprintf(msg+13, "%04X",  g);
    sprintf(msg+17, "%04X",  b);
    sprintf(msg+21, "%04X",  c);
    bool ok = OCTA_LoRa.sendMessage(msg);
    OCTA_LoRa.recieveData(data, 19);    // Read data
    wait(0.2);
    pc.printf("Received:%s \r\n", data);
    
}

int main()
{
    
    //char data[202];
    
    // Assign functions to button1 
    button1.fall(&BTN1pressed);
    button1.rise(&BTN1released);
    
    // Assign functions to button2 
    button2.fall(&BTN2pressed);
    button2.rise(&BTN2released);
    
    //Turn off RGB led
    ledRED = 1;
    ledGreen = 1;
    ledBlue = 1;
    
    //serial communication
    pc.baud(115200);
    pc.printf("Welcome at University of Antwerp #STEM2020 \r\n");
    
    //initialization of the color sensor
    if(!colorSens.init(0xD5, 0x03)){
        pc.printf("ERROR: SENSOR\r\n"); //check to see if i2c is responding
    }
    //initialization of the LoRaWAN module
    if(!OCTA_LoRa.init()){
        pc.printf("ERROR: LoRaWAN module\r\n");
    }
    

    while (1) {
        colorSens.getColor(r,g,b,c); //pass variables by reference...
        pc.printf("DATA: Red: %d Green: %d Blue: %d Clear: %d \r\n", r, g, b, c); // Send sensor data on USB cable to PC
        ledRED = !ledRED; //Toggle LED
        wait(delay);
    }
}
