#include "mbed.h"

Serial pc(USBTX, USBRX);

InterruptIn izolacija(USER_BUTTON); // interrupt za aktiviranje izolacije

AnalogIn nadzor(PC_1); // nadzor tipkala

DigitalIn potvrda(PA_7); // digital input za potvrdu D11
DigitalIn reset(PB_10); // digital input za reset D6
DigitalOut ledAL(PA_9); // digital output za crvenu ledicu D8
DigitalOut ledGR(PA_8); // digital output za zutu ledicu D7
DigitalOut ledRS(PA_10); // digital output za zelenu ledicu D2

void alarm(void);
void greska(void);
void izolacijaF(void);

Timer t_al;
Timer t_gr;
Timer t_ndz;


float f_al = 0.6; // minimalna vrijednost za aktivaciju alarma
float f_gr1 = 0.1; // donja granica za gresku
float f_gr2 = 0.9; // max vrijednost za aktivaciju alarma i gornja vrijednost za gresku

bool IZ = 0; // za aktiviranje izolacije
bool AL = 0; // za stanje alarma
bool GR = 0; // za stanje greske


int main()
{
    izolacija.rise(&izolacijaF); // interruptIn za aktiviranje izolacije

    potvrda.mode(PullDown); // input za povrdu postavljen u PullDown mod
    reset.mode(PullDown); // input za reset postavljen u PullDown mod

    while(1) {
        
        if(IZ == 1) { // uvjet za izolaciju koji se aktivira preko interrupta
            pc.printf("IZOLACIJA! \n\r");
            Timer t_pt;
            AL = 0;
            GR = 0;

            ledAL = 0;
            ledGR = 0;
            ledRS = 1;

            t_pt.start();

            while(IZ == 1) {

                if(AL == 1) {
                    if(t_pt.read_ms() == 500) { // aktivira blinkanje crvene ledica ako se pokusa resetirati izolacija, a alarm je aktivan
                        ledAL =! ledAL;
                    }
                }

                if(t_pt.read_ms() >= 1000) {
                    ledGR =! ledGR;
                    ledRS =! ledRS;
                    t_pt.reset();
                }

                if(reset && f_gr2 > nadzor.read() && nadzor.read() > f_al) { // signalizira da je alarm aktivan ako se pokusa izaci iz izolacije a tipkalo je stisnuto
                    AL = 1;
                }

                if(reset && f_gr1 < nadzor.read() && nadzor.read() < f_al) { // resetiranje izolacije nema greske niti alarma
                    ledAL = 0;
                    ledGR = 0;
                    ledRS = 0;
                    t_pt.stop();
                    t_pt.reset();
                    AL = 0;
                    GR = 0;
                    IZ = 0;
                }
            }
        }
        
        t_ndz.start();

        if(t_ndz.read_ms() > 200) {
            pc.printf("percentage: %3.3f%%\n\r", nadzor.read()); // ispis vrijednosti nadzornog signala
            t_ndz.reset();
        }

        while(f_gr2 > nadzor.read() && nadzor.read() > f_al && IZ == 0) { // uvjet za ALARM
            pc.printf("tipkalo stisnuto \n\r");
            t_al.start();
            if(t_al.read_ms() > 3000) { // ako je stanje alarma aktivno duze od 3 sekundi poziva se funkcija "alarm()"
                AL = 1;
                alarm();
            }
        }
        
        ledAL = 0;
        t_al.stop();
        t_al.reset();

        while(f_gr2 < nadzor.read() && IZ == 0 || nadzor.read() < f_gr1 && IZ == 0) { // uvjet za GRESKU
            t_gr.start();

            if(t_ndz.read_ms() > 200) {  // ispis za nadzor vrijednosti signala
                pc.printf("greska aktivna: %3.3f%%\n\r", nadzor.read());
                ledGR = !ledGR;
                t_ndz.reset();
            }

            if(t_gr.read_ms() > 5000) { // ako je stanje greske aktivno duze od 5 sekundi poziva se funkcija "greska()"
                GR = 1;
                greska();
            }
        }

        ledGR = 0;
        t_gr.stop();
        t_gr.reset();

    }
}

void izolacijaF() // interrupt funkcija za aktiviranje izolacije
{
    IZ = 1;
}

void alarm(void) // funkcija za stanje alarma
{
    Timer t_pt; // timer potvrde
    Timer t_AVC; // izviđanja prije paljenja izvršnih funkcija
    int x = 0;
    bool potvrdeno = 0;

    ledAL = 1;
    pc.printf("ALARM!!! \n\r");
    while(AL == 1 && IZ == 0) {
        t_pt.start();

        if(t_pt.read_ms() >= 1000) { // odbrojavanje 10 sekundi do potvrde ili paljenja izvršnih funkcija
            ledAL =! ledAL;
            x = x + 1;
            t_pt.reset();
        }

        if(x == 10 && potvrdeno == 0) { // ako je proslo 10 sekundi bez potvrde pale se izvrsne funkcije
            pc.printf("x == 10 \n\r Palim signalizaciju! \n\r");
            x = 0;
        }

        if (potvrda == 1) { // prihvacanje potvrde
            potvrdeno = 1;
        }

        if(potvrdeno == 1) { // ako je potvrda prihvacena unutar 10 sekundi
            t_AVC.start();
            ledAL = 1;

            if(t_AVC.read_ms() >= 20000) { // ako nakon potvrde prode 20 sekundi bez reseta pale se izvršne funkcije
                pc.printf("AVC!!! \n\r Palim signalizaciju! \n\r");
            }

            if(reset && nadzor.read() < f_al) { // resetiranje alarma ako je tipkalo nije u alarmnom stanju
                potvrdeno = 0;
                ledAL =0;
                AL = 0;
            }
        }
    }
}

void greska(void) // funckija za stanje greške
{
    Timer t_pt;
    
    ledAL = 0;
    ledRS = 0;
    ledGR = 1;

    pc.printf("GRESKA!!! \n\r");
    while(!potvrda && IZ == 0) { // ceka se potvrda greske
        t_pt.start();

        if(t_pt.read_ms() >= 1000) {
            ledGR =! ledGR;
            t_pt.reset();
        }
    }

    while(f_gr2 > nadzor.read() && nadzor.read() > f_gr1 && IZ == 0 && GR == 1) { // signaliziranje da se moze resetirati potvrdena greska
        t_pt.start();
        
        ledGR = 1;

        if(t_pt.read_ms() >= 1000) {
            ledRS =! ledRS;
            t_pt.reset();
        }

        if(reset == 1 && f_gr2 > nadzor.read() && nadzor.read() > f_gr1) {  // nakon potvrde se moze resetirati ako tipkalo nije u gresci niti alarm
            ledGR = 0;
            ledRS = 0;
            GR = 0;
            t_pt.stop();
            t_pt.reset();
        }
    }
}