// ======================================================================

#include "mbed.h"
#include "ESP-call.h"

// ======================================================================
// NodeMCU program

NodeMCU_PGM simple_timer[] = {
    "", 1,
    "delayms = 500", 1,
    "", 1,
    "LEDpin = 4", 1,
    "LEDstate = 0", 1,
    "", 1,
    "gpio.mode(LEDpin,gpio.OUTPUT)", 1,
    "", 1,
    "function toggle()", 1,
    "  if (LEDstate) then gpio.write(LEDpin,gpio.LOW)", 1,
    "                else gpio.write(LEDpin,gpio.HIGH)", 1,
    "  end", 1,
    "  LEDstate = not LEDstate", 1,
    "end", 1,
    "", 1,
    "mytimer = tmr.create()", 1,
    "mytimer:register(delayms, tmr.ALARM_AUTO, function () toggle() end)", 1,
    "mytimer:start()", 1,
    NULL, 0,       // last line should be NULL and 0
};

// ======================================================================
// Main thread

int main()
{
    int i;
    char *p;

    // Config baudrate of PC and ESP
    PC.baud(115200);
    ESP.baud(115200);

    // Reset ESP
    PC.printf("\r\nReset ESP...\r\n");
    ESP_reset();

    // Setup ESP noecho mode
    PC.printf("Setup ESP noecho...\r\n");
    ESP_noecho();

    // Execute a NodeMCU program
    PC.printf("Execute a NodeMCU program...\r\n");
    ESP_call_multi(simple_timer);

    // Setup ESP echo mode
    PC.printf("\r\nSetup ESP echo...\r\n");
    ESP_echo();

    // Config ESP passthrough mode
    PC.printf("ESP passthrough mode...\r\n");
    PC.attach(&ISR_PC_to_ESP, Serial::RxIrq);
    ESP.attach(&ISR_ESP_to_PC, Serial::RxIrq);

    // Main thread sleeps
    while(1) {
        sleep();
    }
}

// ======================================================================