/*
* @author Jinhyuk Yoon
*
* Designed to control ESCON via NUCELO-F767ZI
*/


#include "ESCON_rpm.h"

ESCON_rpm::ESCON_rpm(PinName rpm_in_pin, double min_volt_, double max_volt_, double min_rpm_, double max_rpm_) : rpm(rpm_in_pin) {
    min_volt = min_volt_;
    max_volt = max_volt_;
    min_rpm = min_rpm_;
    max_rpm = max_rpm_;
    grad = (max_rpm - min_rpm) / (max_volt - min_volt);
}

double ESCON_rpm::read(void) {
    return grad*(rpm*(max_volt-min_volt) - min_volt) + min_rpm;
}
