/**
* @author Jinhyuk Yoon
*
* Designed to control ESCON via NUCELO-F767ZI

**/


#include "mbed.h"
#define PI 3.14159265358979323846

class ESCON_motor {
private:
    DigitalOut enable_;
    DigitalOut dir_;
    PwmOut pwm_;
    double period;
    double duty_cycle;
    
    
public:
    /* 
    * @param  _enable_out_pin  digital out pin name which controls enable.
    * @param  _dir_out_pin  digital out pin name which controls diretion.
    * @param  _pwm_out_pin  pwm out pin name whcih controls pwm signal.
    * @param  duty_cycle  value between 0.0 and 1.0. (0.5 means 50% duty cycle.)
    * @param motor_time_const  can be found in motor spec. Unit is millesecond(ms)
    */
    ESCON_motor(PinName _enable_out_pin, PinName _dir_out_pin, PinName _pwm_out_pin, double _duty_cycle, double motor_time_const);
    void enable(void);
    void disable(void);
    void CW(void);
    void CCW(void);
    void pwm(void);
    void pwmDutyCycleChange(double _duty_cycle);
};