/*
* @author Jinhyuk Yoon
*
* Designed to control ESCON via NUCELO-F767ZI
*/

#include "ESCON_motor.h"

ESCON_motor::ESCON_motor(PinName enable_out_pin,
                         PinName dir_out_pin,
                         PinName pwm_out_pin,
                         double duty_cycle_,
                         double motor_time_const) : enable_(enable_out_pin),
                         dir_(dir_out_pin),
                         pwm_(pwm_out_pin){
                             
    duty_cycle = duty_cycle_;
    period = 1 / (5 * 1000 / (2 * PI * motor_time_const) ) ;
   /*
    * Calcuate maximum period based on cutoff frequency for motor actuation.
    * Motor time constant's unit is millesecond(ms).
    * Source: https://electronics.stackexchange.com/questions/242293/is-there-an-ideal-pwm-frequency-for-dc-brush-motors
    */
}

void ESCON_motor::enable(void) { enable_ = 1;}

void ESCON_motor::disable(void) { enable_ = 0; }

void ESCON_motor::CW(void) { dir_ = 0; }

void ESCON_motor::CCW(void) { dir_ = 1; }

void ESCON_motor::pwm(void) {
    pwm_.period(period);
    pwm_.pulsewidth(duty_cycle * period);
}

void ESCON_motor::pwmDutyCycleChange(double duty_cycle_) {
    duty_cycle = duty_cycle_;
    pwm_.period(period);
    pwm_.pulsewidth(duty_cycle * period);
}