/*
* @author Jinhyuk Yoon
*
* Designed to control ESCON via NUCELO-F767ZI
*/

#include "mbed.h"
#define PI 3.14159265358979323846

#define PREV_MASK 0x1 //Mask for the previous state in determining direction
//of rotation.
#define CURR_MASK 0x2 //Mask for the current state in determining direction
//of rotation.
#define INVALID   0x3 //XORing two states where both bits have changed.

class ESCON_encoder {
private:
    void encode(void);
    
    InterruptIn     channelA;
    InterruptIn     channelB;

    int             count_per_turn;
    int             prevState;
    int             currState;

    volatile int    pulses;
    volatile int    revolutions;
    volatile double pos_in_degree;
    volatile double pos_in_radian;
    
public:
    ESCON_encoder(PinName channelA_, PinName channelB_, int count_per_turn_);
    void reset(void);
    int getCurrentState(void);
    int getPulses(void);
    double getPosInDegree(void);
    double getPosInRadian(void);
    int getRevolutions(void);
};