#include "mbed.h"
#include "ConfigFile.h"
//#include "SDFileSystem.h"

ConfigFile cfg;
LocalFileSystem local("local");

/*
 * ==================================================
 * Definition of "LINE"
 * ==================================================
 *
 * C1  C2  C3  C4  C5
 * --------------------
 * L1  L2  L3  L4  L5
 * L6  L7  L8  L9  L10
 * L11 L12 L13 L14 L15
 * L16 L17 L18 L19 L20
 * L21 L22 L23 L24 L25
 *
 * ==================================================
 */
 
BusOut leds(LED1, LED2, LED3, LED4);
DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);
DigitalOut C1(p25); //line1 to line5
DigitalOut C2(p24); //line6 to line10
DigitalOut C3(p23); //line11 to line15
DigitalOut C4(p22); //line16 to line20
DigitalOut C5(p21); //line21 to line25
//DigitalOut Call[] = {p25, p24, p23, p22, p21};
DigitalOut mclock(p5); //mainclock
DigitalOut sclock(p6); //subclock
AnalogIn volume(p20);
DigitalIn resets(p19);
DigitalIn replay(p18);
DigitalIn start(p17);
Ticker timer;

/* ==================================================
 * Not implemented
 * ==================================================

// MicroSD Ssytem
#include "SDFileSystem.h"
#define     SD_MOSI     p5
#define     SD_MISO     p6
#define     SD_SCLK     p7
#define     SD_CS       p8
 
//SDFileSystem    sd(p11, p12, p13, p9, "sd");  //  mosi, miso, sclk, cs, name
SDFileSystem  sd(SD_MOSI, SD_MISO, SD_SCLK, SD_CS,  "sd");  //  mosi, miso, sclk, cs, name  (HW modification candidate)
*/

/* ==================================================
 * Debug mode switch
 * ==================================================
 * if(debug == 1)
 * {
 *     printf("");
 * }
 * if(debug == 0)
 * {
 *     //printf("");
 * }
 */
int debug = 0;

void time() {
    led1 = 1;
    wait_ms(50);
    led1 = 0;
    wait_ms(50);
}

int main() {
    start:
    if(debug == 1){
        printf("LoadingProgram...\n");
        printf("Loaded.\n");
    }
    while(1){
        if(start == 1){
            if(debug == 1){
                printf("Start!\n");
            }
            goto replay;
        } else {
            //timer.attach(&time, 0.05);
            led4 = 1;
            wait(volume);
            led4 = 0;
            wait(volume);
        }//else
    }//while
    replay:
    float speed = volume;
    if(debug == 1){
        printf("This program will Set Pattern in %f sec.\n",speed);
    }
    //error
    if (!cfg.read("/local/pattern.cfg")) {
        if(debug == 1){
            printf("Failure to read a configuration file.\n");
        }
        while(1){
            leds = 15;
            wait(0.1);
            leds = 0;
            wait(0.1);
        }
    }
    
    //read file
    if(debug == 1){
        printf("reading file...\n");
    }
    cfg.read("/local/pattern.cfg");
    
    const int cnt = cfg.getCount();
    char buf_key[BUFSIZ];
    char buf_value[BUFSIZ];
    
    long sin2;
    
    for (int i = 0; i < cnt; i++) {
        leds = 0;
        if (cfg.getKeyAndValue(i, buf_key, sizeof(buf_key), buf_value, sizeof(buf_value))) {
            
            sin2 = strtol(buf_value, NULL, 2);
            if(debug == 1){
                printf("%d = %d\n", i+1, sin2);
            }
            
            //SetPattern
            if(debug == 1){
                printf("SetPattern\n");
            }
            if((i+1) % 5 == 0){
                if(debug == 1){
                    printf("(i+1) % 5 == 0\n");
                }
            } else {
                C5 = sin2 & 0x1;
                C4 = (sin2 >> 1) & 0x1;
                C3 = (sin2 >> 2) & 0x1;
                C2 = (sin2 >> 3) & 0x1;
                C1 = (sin2 >> 4) & 0x1;
                if(debug == 1){
                    printf("C1:%d,C2:%d,C3:%d,C4:%d,C5:%d\n",(sin2 >> 4) & 0x1,(sin2 >> 3) & 0x1,(sin2 >> 2) & 0x1,(sin2 >> 1) & 0x1,sin2 & 0x1);
                }
                sclock = 1;
                leds = i+1;
                wait_ms(50);
                leds = 0;
                //Switch to Next Pattern
                if((i+1) % 5 == 4){
                    mclock = 1;
                    leds = 15;
                    wait(volume);
                    if(debug == 1){
                        printf("Switch to Next Pattern\n");
                    }
                }
                sclock = 0;
                mclock = 0;
            }
        } else {
            if(debug == 1){
                printf("No.%3d:Failure to get a configuration.\n", i);
            }
        }//else
    }//for
    if(debug == 1){
        printf("Done.\n");
    }
    while(1){
        if(resets == 1){
            if(debug == 1){
                printf("Reset!\n");
            }
            C1 = 0;
            C2 = 0;
            C3 = 0;
            C4 = 0;
            C5 = 0;
            for(int i = 0; i < 5; i++){
                sclock = 1;
                wait_ms(10);
                sclock = 0;
            }//for
            for(int i = 0; i < 5; i++){
                mclock = 1;
                wait_ms(10);
                mclock = 0;
            }//for
        goto start;
        }//if
        if(replay == 1){
            if(debug == 1){
                printf("Restart!\n");
            }
            goto replay;
        }
    }//while
    goto start;
}//main