/**
  WIP raycasting demo for Pokitto.

  author: Miloslav "drummyfish" Ciz
  license: CC0
 */

#include <stdio.h>
#include "raycastlib.h"
#include "Pokitto.h"
#include <stdlib.h>

class Level
{
public:
  int16_t getHeight(int16_t x, int16_t y)
  {
    if (x > 12 || y > 12)
      return max(x,y) - 10;

    if (y < 5 && y > 2)
      return x;

    return (x < 0 || y < 0 || x > 9 || y > 9) ? 4 : 0;
  }
};

class Character
{
public:
  Camera mCamera;

  Character()
  {
    mCamera.position.x = 400;
    mCamera.position.y = 6811;
    mCamera.direction = 660;
    mCamera.fovAngle = UNITS_PER_SQUARE / 4;
    mCamera.height = 0;
    mCamera.resolution.x = 36;
    mCamera.resolution.y = 88;
  } 
};

Pokitto::Core p;
Character player;
Level level;

Unit heightFunc(int16_t x, int16_t y)
{
  return level.getHeight(x,y) * UNITS_PER_SQUARE / 4;
}

bool dither(uint8_t intensity, uint32_t x, uint32_t y)
{
  switch (intensity)
  {
    case 0: return false; break;
    case 1: return x % 2 == 0 && y % 2 == 0; break;
    case 2: return x % 2 == y % 2; break;
    case 3: return x % 2 != 0 || y % 2 != 0; break;
    default: return true; break;
  }
}

void pixelFunc(PixelInfo pixel)
{
  uint8_t c = pixel.isWall ? pixel.hit.direction + 4 : 3;

  uint16_t x = pixel.position.x * 3;
  uint16_t y = pixel.position.y;

  uint8_t d = pixel.depth / (UNITS_PER_SQUARE * 2);

  p.display.color = dither(d,x,y) ? 0 : c;
  p.display.drawPixel(x,pixel.position.y);

  x++;

  p.display.color = dither(d,x,y) ? 0 : c;
  p.display.drawPixel(x,pixel.position.y);

  x++;

  p.display.color = dither(d,x,y) ? 0 : c;
  p.display.drawPixel(x,pixel.position.y);
}

void draw()
{

  RayConstraints c;

  c.maxHits = 3;
  c.maxSteps = 10;

  render(player.mCamera,heightFunc,pixelFunc,c);

}

int main()
{
  p.begin();

  p.setFrameRate(30);

  p.display.setFont(fontTiny);

  while (p.isRunning())
  {
    if (p.update())
    {
      draw();

      const int16_t step = 50;
      const int16_t step2 = 10;

      Vector2D d = angleToDirection(player.mCamera.direction);

      d.x = (d.x * step) / UNITS_PER_SQUARE;
      d.y = (d.y * step) / UNITS_PER_SQUARE;

      if (p.upBtn())
      {
        player.mCamera.position.x += d.x;
        player.mCamera.position.y += d.y;
      }
      else if (p.downBtn())
      {
        player.mCamera.position.x -= d.x;
        player.mCamera.position.y -= d.y;
      }

      if (p.rightBtn())
        player.mCamera.direction += step2;
      else if (p.leftBtn())
        player.mCamera.direction -= step2;

      if (p.bBtn())
        player.mCamera.height += step;
      else if (p.cBtn())
        player.mCamera.height -= step;
    }
  }

  return 0;
}