#include "mbed.h"

//Zustände Lampen
#define VORNE_AUS 0
#define VORNE_LEUCHTEN 1
#define VORNE_BLINKEN 2
#define VORNE_BLINKENSCHNELL 3
#define HINTEN_AUS 0
#define HINTEN_LEUCHTEN 1
#define HINTEN_BLINKEN 2
#define ZUSTAND_MAX_VORNE 4
#define ZUSTAND_MAX_HINTEN 3


PwmOut InN(D3);
Timer timer1;
AnalogIn SpannungHallSensor(A0);
AnalogIn SpannungVorKabel(A3);
AnalogIn SpannungNachKabel(A4);

Serial pc(SERIAL_TX, SERIAL_RX); // PINS EINSTELLEN!


DigitalIn BremsTaster(PC_0);

DigitalOut LampeVorne(PA_4);    //Scheinwerfer
DigitalOut LampeHinten(PA_5);

/*
DigitalOut EnableUSB(PB_12);


AnalogIn SpannungBatterie(PB_0);
AnalogIn SpannungNachPMOS(PB_2);


Serial Bluetooth(SERIAL_TX, SERIAL_RX);



*/

const float Kabel_Widerstand = 0.32;

const int PERIODEN_DAUER = 20000;

const float MAX_LADUNG = 5800;
const float MAX_ABFLUSS = 5000;


int time1;
float vol_vorher, akkustand, strom, akku_abfluss;
float vol_nachher;


void SpannungVorher(){
    vol_vorher = 0;
    
    for (int i = 0; i < 300; i++) {
        vol_vorher += SpannungVorKabel.read() * 3.3 * 6;
    }
    vol_vorher /= 300;
}

void SpannungNachher(){
    vol_nachher = 0;
    
    for (int i = 0; i < 300; i++) {
        vol_nachher += SpannungNachKabel.read() * 3.3 * 6;
    }
    vol_nachher /= 300;
}

       
float HallSensorWert(){
    float messung;
    messung = SpannungHallSensor.read() - 0.27; // read adc and rearange the voltage_value,because its 0.27 when the throttle is off
    
    if(messung < 0){          // meas0 isnt allowed to be <0 because its sets the pulsewidht of the pwm
        messung = 0;
    }
    
    messung *= 2;  // creates values between 0 and 1
    
    if(messung > 1){      // meas0 isnt allowed to be >1 because its sets the pulsewidth of the pwm 
        messung = 1;
    }
    
    return messung;
}

int BremsTasterWert(){
    int TasterWert;  
    TasterWert = BremsTaster.read(); // read breaksensor value(1/0)
    return TasterWert; // return value
}



int ZustandVorne = 0;
int ZustandHinten = 0;

void LichtEinstellenVorne(int ZustandNeu) {
    while (ZustandVorne != ZustandNeu) {
        LampeVorne = 1;
        wait_ms(50);
        LampeVorne = 0;
        ZustandVorne++;
        if (ZustandVorne == ZUSTAND_MAX_VORNE) ZustandVorne = 0;
    }
}
    
void LichtEinstellenHinten(int ZustandNeu) {
    while (ZustandHinten != ZustandNeu) {
        LampeHinten = 1;
        wait_ms(50);
        LampeHinten = 0;
        ZustandHinten++;
        if (ZustandHinten == ZUSTAND_MAX_HINTEN) ZustandHinten = 0;
    }
}

float HallSensorWertM = 0;

void MotorInit() {
    InN.period_ms(PERIODEN_DAUER);
    InN.pulsewidth_us(0);
}

void GeschwindigkeitSetzen(){    
        HallSensorWertM = HallSensorWert();

        InN.pulsewidth_us(PERIODEN_DAUER*HallSensorWertM);
}

    
float Ladung_Abfluss(int time, float vol_vorher,float vol_nachher){
    float ladung;
    strom = (vol_vorher - vol_nachher) / (Kabel_Widerstand);
    ladung = strom*time;
    akku_abfluss = akku_abfluss + ladung;
    return akku_abfluss;
    
}
    
void MessungInit() {
    time1 = 0;
    vol_vorher = 0, akkustand = 0, akku_abfluss = 0;
    vol_nachher = 0;
}

void MessungStarten() {
        timer1.start();
        SpannungVorher();
        SpannungNachher();
}

void MessungStoppen() {
    time1 = timer1.read_us();
    timer1.stop();
    timer1.reset();
    akkustand = MAX_LADUNG - Ladung_Abfluss(time1, vol_vorher, vol_nachher);
    pc.printf("Spannung_Batterie=%f, Spannung_nachher=%f, Strom=%f, Akkustand=%f --- \n",vol_vorher,vol_nachher, strom, akkustand);
}

    

int main() {
    
    MotorInit();
    MessungInit();

    while(1) {

        MessungStarten();
        
        if (vol_vorher > 13.2) {
            GeschwindigkeitSetzen();
        }
        
        MessungStoppen();
        
    }
}
