//Hat Board v5 by Cooke Scharf 4/2/2014

#include "mbed.h"
#include "SI_LIS.h"
#include <time.h>

#include "arm_math.h"
#include "math_helper.h"
#include "dsp.h"
#include "arm_const_structs.h"

DigitalOut  myled3(LED3);
DigitalOut  myled4(LED4);
Serial      pc(USBTX,USBRX);
DigitalIn   int_pin(p8);
Timer       t;

int         t_usec;
int         reading_IR,reading_660,LSB,MSB;
char        rx_data[4];
char        accel_data[6];
char        temp_val;
short int   dataX;     // short int: 16 bits.  This allows easy negative results
short int   dataY;     // short int: 16 bits.  This allows easy negative results
short int   dataZ;     // short int: 16 bits.  This allows easy negative results
float       t_msec;
float       dataX_fl;
float       dataY_fl;
float       dataZ_fl;
//float       accel_fl;

////////////////////////////////////////////
///////////////////////////////////////////
#define         MAX_BLOCKSIZE   4096
uint32_t        fftsize = MAX_BLOCKSIZE/2;
const static    arm_cfft_instance_f32 *S;

///////////////////////////////////////////
long int        BAUD_RATE = 230400;
void baud(int baudrate)
{
    Serial s(USBTX,USBRX);
    s.baud(baudrate);
}

///////////////////////////////////////////
unsigned short  i,j,k, m;
float32_t       temp;
float32_t       temp2;
float           sclr;

float32_t       v[MAX_BLOCKSIZE], w[MAX_BLOCKSIZE], acc[MAX_BLOCKSIZE];
float32_t       testoutput[MAX_BLOCKSIZE/2];
float32_t       testoutputb[26], testoutputc[26], outputacc[26];

////////////////////////////////////////////

int main()
{
    t.start();
    myled4 = 0;
    pc.baud(460800);
    Init_Accel();   // starts LIS3DH
    restart();      // starts Si1142
    wait_ms(30);
    command (PS_AUTO);   //start measuring
    wait (0.5);

    j = 0;

    while(1) {
        if(!int_pin) {

            write_reg(IRQ_STATUS,0x04);  // clear the interrupt.

            read_reg2(PS1_DATA0);
            reading_IR  = rx_data[1] << 8 | rx_data[0];
            reading_660 = rx_data[3] << 8 | rx_data[1];

            Get_Accel_Reg_6 (0x28);

            dataX = accel_data[1] << 8 | accel_data[0];
            dataY = accel_data[3] << 8 | accel_data[2];
            dataZ = accel_data[5] << 8 | accel_data[4];

            k = (j/2)*2;
            if (j==k) {
                v[j] = (float32_t)reading_IR;
                v[j+1] = 0;
                w[j] = (float32_t)reading_660;
                w[j+1] = 0;

                dataX_fl = (float) dataX;
                dataY_fl = (float) dataY;
                dataZ_fl = (float) dataZ;

                acc[j]   = sqrt( (dataX_fl*dataX_fl) + (dataY_fl*dataY_fl) + (dataZ_fl*dataZ_fl) );
                acc[j+1] = 0;

            }
//            pc.printf ("%4d  %5d  %5d  %5d  %5d  %5d\n\r", j, reading_IR, reading_660, dataX, dataY, dataZ);

            j= j + 2;

            if(j==MAX_BLOCKSIZE) {

                switch (fftsize) {
                    case 64:
                        S = & arm_cfft_sR_f32_len64;
                        break;
                    case 128:
                        S = & arm_cfft_sR_f32_len128;
                        break;
                    case 256:
                        S = & arm_cfft_sR_f32_len256;
                        break;
                    case 512:
                        S = & arm_cfft_sR_f32_len512;
                        break;
                    case 1024:
                        S = & arm_cfft_sR_f32_len1024;
                        break;
                    case 2048:
                        S = & arm_cfft_sR_f32_len2048;
                        break;
                    case 4096:
                        S = & arm_cfft_sR_f32_len4096;
                        break;
                }

/////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////////
                float32_t   maxvaluea, maxvalueb, maxacc, rvalue, spo2;
                uint32_t    testindexa, testindexb, indexacc;

                t.reset();

                for (i = 0; i < 26; i++) {
//                                   pc.printf ("\n\r%4d  %10.2f  %10.2f  %10.2f\n\r", i, v[i], w[i], acc[i]);
                }

/////////////////////////////////////////////////////////////////////
                arm_cfft_f32(S, v, 0, 1);
                arm_cmplx_mag_squared_f32(v, testoutput, fftsize);
                sclr = 1000000/testoutput[0];
                arm_scale_f32(testoutput, sclr, testoutput, fftsize);

                for (i = 0; i < 26; i++) {
                    testoutputb[i] = testoutput[i];
                    if (i<4) {
                        testoutputb[i] = 0;
                    }
//                                   pc.printf ("\n\r%4d  %10.2f\n\r", i, testoutputb[i]);
                }
                // 805 nm
                arm_max_f32(testoutputb, 26, &maxvalueb, &testindexb);      // 720 hz sampling / 4096 fft = 0.1758 hz bin spacing = 360 hz sampling / 2048 fft
                // 1 beat-sec / 0.1758 = about 6 bins (HR = 60 bpm)
                // 3.6667 beats-sec / 0.1758 hz bin spacing = about 21 bins (HR = 220 bpm)
//        pc.printf ("\n\r\n\r%4d  %10.3f\n\r\n\r", testindexb, maxvalueb);

/////////////////////////////////////////////////////////////////////
                arm_cfft_f32(S, w, 0, 1);
                arm_cmplx_mag_squared_f32(w, testoutput, fftsize);
                sclr = 1000000/testoutput[0];
                arm_scale_f32(testoutput, sclr, testoutput, fftsize);

                for (i = 0; i < 26; i++) {
                    testoutputc[i] = testoutput[i];
                    if (i<4) {
                        testoutputc[i] = 0;
                    }
                }
                // 660 nm
                arm_max_f32(testoutputc, 26, &maxvaluea, &testindexa);      // 720 hz sampling / 4096 fft = 0.1758 hz bin spacing = 360 hz sampling / 2048 fft
                // 1 beat-sec / 0.1758 = about 6 bins (HR = 60 bpm)
                // 3.6667 beats-sec / 0.1758 hz bin spacing = about 21 bins (HR = 220 bpm)
//        pc.printf ("\n\r\n\r%4d  %10.3f\n\r\n\r", testindexa, maxvaluea);

                rvalue = maxvaluea/maxvalueb;
                spo2 = -22.6 * rvalue + 108;

        pc.printf ("\n\r\n\r%5.2f  %5.2f\n\r\n\r", rvalue, spo2);

/////////////////////////////////////////////////////////////////////
                arm_cfft_f32(S, acc, 0, 1);
                arm_cmplx_mag_squared_f32(acc, testoutput, fftsize);
                sclr = 1000000/testoutput[0];
                arm_scale_f32(testoutput, sclr, testoutput, fftsize);

                for (i = 0; i < 26; i++) {
                    outputacc[i] = testoutput[i];
                    if (i<4) {
                        outputacc[i] = 0;
                    }
//                                   pc.printf ("\n\r%4d  %10.2f\n\r", i, outputacc[i]);
                }
                // accelerometer
                arm_max_f32(outputacc, 26, &maxacc, &indexacc);             // 720 hz sampling / 4096 fft = 0.1758 hz bin spacing = 360 hz sampling / 2048 fft
                // 1 beat-sec / 0.1758 = about 6 bins (HR = 60 bpm)
                // 3.6667 beats-sec / 0.1758 hz bin spacing = about 21 bins (HR = 220 bpm)
//        pc.printf ("\n\r\n\r%4d  %10.3f\n\r\n\r", indexacc, maxacc);

/////////////////////////////////////////////////////////////////////

                j = 0;
                t_usec = t.read_us();
                pc.printf ("FFT's etc: %d us\n",t_usec);

/////////////////////////////////////////////////////////////////////

            }

//----------------------------------------------------------
        }
    }
}

