//Hat Board Test by James Cooke 3/18/2014
//Goal of  program: read and output data from LIS3DH accelerometer
//Started with Si_4088_PC working program: able to get data from Si1142 on new hat board

#include "mbed.h"
#include "SI_LIS.h"
#include <time.h>

DigitalOut  myled3(LED3);
DigitalOut  myled4(LED4);
Serial      pc(USBTX,USBRX);
DigitalIn   int_pin(p8);
Timer       t;

int         reading_IR,reading_660,LSB,MSB;
char        rx_data[4];
char        accel_data[6];
char        temp_val;
short int   dataX;     // short int: 16 bits.  This allows easy negative results
short int   dataY;     // short int: 16 bits.  This allows easy negative results
short int   dataZ;     // short int: 16 bits.  This allows easy negative results
float       t_msec;
float       dataX_fl;
float       dataY_fl;
float       dataZ_fl;
float       accel_fl;

int main()
{
    // To test:  Block data update (CTRL_REG4);  1.25 KHz data;  low power vs normal power

    myled4 = 0;  // ODD: if this line not included, there is a compiler "internal error"
    pc.baud(460800);
    Init_Accel();   // starts LIS3DH
    restart();      // starts Si1142

    wait_ms(30);
    command (PS_AUTO);   //start measuring
    wait (0.5);

    while(1) {
        if(!int_pin) {
            t.reset();
            t.start();

            write_reg(IRQ_STATUS,0x04);  // clear the interrupt.

            read_reg2(PS1_DATA0);
            reading_IR  = rx_data[1] << 8 | rx_data[0];
            reading_660 = rx_data[3] << 8 | rx_data[1];

            pc.printf ("%d, %d, ", reading_IR,reading_660);

            Get_Accel_Reg_6 (0x28);

            dataX = accel_data[1] << 8 | accel_data[0];
            dataX_fl = (float) dataX;
            dataY = accel_data[3] << 8 | accel_data[2];
            dataY_fl = (float) dataY;
            dataZ = accel_data[5] << 8 | accel_data[4];
            dataZ_fl = (float) dataZ;
            accel_fl = sqrt( (dataX_fl*dataX_fl) + (dataY_fl*dataY_fl) + (dataZ_fl*dataZ_fl) );
            pc.printf ("%6.0f ",accel_fl);

            t.stop();
            t_msec = t.read() * 1000;
            printf("%6.3f msec\n", t_msec);
        }
    }
}
/*
Notes on RJ-45: Pin 1: Vcc  Pin 2: GND  Pin 3: SDA > 9 on 4088
                Pin 4: SCL >> 10 on 4088  Pin 6: INT > 8 on 4088

Bluetooth:  Tx on 4088: Pin 37 >> RX   Rx on 4088: Pin 31 >> TX
PC COMM port on Square board: 12

*/