// uLCD-144-G2 demo program for uLCD-4GL LCD driver library
//
#include "mbed.h"
#include "math.h"
#include "uLCD_4DGL.h"
#define PI 3.14159265358979323846

uLCD_4DGL uLCD(p9,p10,p11); // serial tx, serial rx, reset pin;
AnalogIn a1(p19);
AnalogIn a2(p20);
DigitalIn start(p18);

int bx = 64;
int by = 64;
int P1x1 = 0, P1x2 = 3, P1y1, P1y2;
int P2x1 = 124, P2x2 = 127, P2y1, P2y2;
float angle;
int speed;
int P1S = 0, P2S = 0;
int hold, h1, h2;



int main()
{

//    // basic printf demo = 16 by 18 characters on screen
//    uLCD.printf("\nHello uLCD World\n"); //Default Green on black text
//    uLCD.printf("\n  Starting Demo...");
//    uLCD.text_width(4); //4X size text
//    uLCD.text_height(4);
//    uLCD.color(RED);
//    for (int i=5; i>=0; --i) {
//        uLCD.locate(1,2);
//        uLCD.printf("%2D",i);
//        wait(.5);
//
//    }
//    uLCD.cls();


    uLCD.text_width(1);
    uLCD.text_height(1);
    uLCD.baudrate(300000);

    // Initialize random angle between 0 and 360
    srand (time(NULL));
    do {
        angle = rand()%361;
    } while ((angle<20)||(angle>70&&angle<110)||(angle>160&&angle<200)||(angle>250&&angle<290)||(angle>340));

    /////////////////////////////////////////////////////

    while(1) {
        if (start==0) {
            hold=0;
            h1=0;
            h2=0;
        }

        if (hold==1)
            speed=0;
        else
            speed=5;
            
        // Set position of the paddles
        P1y1 = (a1*103)+8;
        P1y2 = P1y1 + 16;
        P2y1 = (a2*103+8);
        P2y2 = P2y1 + 16;

        // Control motion of ball
        uLCD.filled_circle(bx, by , 2, 0);

        if((bx>122 && (by>P2y1 && by<P2y2)) || (bx<5 && (by>P1y1 && by<P1y2)))
            angle = 180 - angle;       
        else if(by>125 || by<10)// I think this is where our problem is
            angle = -angle;

        //P1 Scores
        else if(bx>122) {
            P1S++;
            bx = 5;
            by = P1y1+8;
            hold=1;
            h1=1;
            angle = rand()%120+120+180;

            //P2 Scores
        } else if(bx<5) {
            P2S++;
            bx = 122;
            by = P2y1+8;
            hold=1;
            h2=1;
            angle = rand()%120+120;
        }

        if (hold==1&&h1==1) {
            bx = 6;
            by = P1y1+8;
        } else if (hold==1&&h2==1) {
            bx = 121;
            by = P2y1+8;
        } else {
            bx = bx + speed*cos(angle*2*PI/360);
            by = by - speed*sin(angle*2*PI/360);
        }

        // Print paddles and ball
        uLCD.filled_circle(bx, by, 2, 0xffffff);
        uLCD.filled_rectangle(0, P1y1, 3, P1y2, 0xffffff);
        uLCD.filled_rectangle(124, P2y1, 127, P2y2, 0xffffff);
        uLCD.filled_rectangle(0, 9, 3, P1y1-1, 0);
        uLCD.filled_rectangle(0, P1y2+1, 3, 127, 0);
        uLCD.filled_rectangle(124, 9, 127, P2y1-1, 0);
        uLCD.filled_rectangle(124, P2y2+1, 127, 127, 0);
        uLCD.line(5, 8, 122, 8, 0xffffff);

        // Print scores
        uLCD.locate(2,0);
        uLCD.printf("P1: %d    P2: %d",P1S,P2S);
        wait(.005);
    }

}
