#include "mbed.h"
#include "EaEpaper.h"
#include "Arial28x28.h"
#include "Arial12x12.h"
#include "font_big.h"
#include "graphics.h"

EaEpaper epaper(PTD7,            // PWR_CTRL
                PTD6,            // BORDER
                PTE31,           // DISCHARGE
                PTA17,           // RESET_DISP
                PTA16,           // BUSY
                PTC17,           // SSEL
                PTD4,            // PWM
                PTD2,PTD3,PTD1,  // MOSI,MISO,SCLK
                PTE0,PTE1);      // SDA,SDL 
 
int main() {

    epaper.cls();
    epaper.set_font((unsigned char*) Arial28x28);  // select the font
    epaper.locate(5,20);
    epaper.printf("Hello Mbed");
    epaper.rect(3,15,150,50,1);
     
    epaper.set_font((unsigned char*) Arial12x12);
    epaper.locate(5,60);
    epaper.printf("small Font");
    epaper.set_font((unsigned char*) Neu42x35);
    epaper.locate(5,70);
    epaper.printf("big Font");
    
    epaper.write_disp(); // update screen
    
    wait(5);
    epaper.fillcircle(180,30,22,1);
    epaper.circle(160,150,20,1);
    epaper.write_disp(); // update screen
   
}
