/**
  * Demo for the RGB Led on the mbed Lab Board
  * Pot 2 changes the color 
  * Pot 1 changes the value
  * the saturation is set to maximum
  * 
  * Copyright (c) 2012 Peter Drescher - DC2PD
  * This Demo run only on LPC1768 !
  * The LPC11U24 has different PWM pins !
  */   


#include "mbed.h"
#include "C12832_lcd.h"
#include "Small_7.h"
#include "Arial_9.h"
//#include "stdio.h"


// LCD object
C12832_LCD lcd;

/* the led's are connected to vcc, so a PwmOut of 100% will shut off the led and 0% will let it shine ! */
PwmOut r (p23);
PwmOut g (p24);
PwmOut b (p25);

AnalogIn Pot1(p19);
AnalogIn Pot2(p20);

// function to convert hue , saturation and  value to RGB
// see http://en.wikipedia.org/wiki/HSL_and_HSV
void hsv2rgb(float H,float S, float V)
{
    float f,h,p,q,t;
    int i;
    if( S == 0.0) {
        r = 1.0 - V;  // invert pwm !
        g = 1.0 - V;
        b = 1.0 - V;
        return;
    }
    if(H > 360.0) H = 0.0;   // check values
    if(S > 1.0) S = 1.0; 
    if(S < 0.0) S = 0.0;
    if(V > 1.0) V = 1.0;
    if(V < 0.0) V = 0.0;
    h = H / 60.0;
    i = (int) h;
    f = h - i;
    p = V * (1.0 - S);
    q = V * (1.0 - (S * f));
    t = V * (1.0 - (S * (1.0 - f)));

    switch(i) {
        case 0:
            r = 1.0 - V;  // invert pwm !
            g = 1.0 - t;
            b = 1.0 - p;
            break;
        case 1:
            r = 1.0 - q;
            g = 1.0 - V;
            b = 1.0 - p;
            break;
        case 2:
            r = 1.0 - p;
            g = 1.0 - V;
            b = 1.0 - t;
            break;
        case 3:
            r = 1.0 - p;
            g = 1.0 - q;
            b = 1.0 - V;
            break;
        case 4:
            r = 1.0 - t;
            g = 1.0 - p;
            b = 1.0 - V;
            break;
        case 5:
        default:
            r = 1.0 - V;
            g = 1.0 - p;
            b = 1.0 - q;
            break;
    }
}

    
int main()
{
    float h;       //  hue 
    float s,v;   // saturation and  value;
    unsigned short temp;
    
    lcd.cls();
    lcd.locate(10,0);
    lcd.set_font((unsigned char*) Arial_9);
    lcd.printf("RGB Led Demo");
    lcd.set_font((unsigned char*) Small_7);
    
    r.period(0.001);  // set pwm period
    s = 1.0;
    for(;;){
        // get Poti 1 for color
        temp = Pot1.read_u16();
        temp = temp >> 6;        // truncate to 10 Bit
        h = temp * 0.3515625;  // scale to 0 - 360;
        lcd.locate(0,13);
        lcd.printf("Colour = %3.2f degree",h);
        // get Poti 2 fo value
        temp = Pot2.read_u16();
        temp = temp >> 6;
        v = temp * 0.0009765624;  // scale to 0 - 1;
        lcd.locate(0,23);
        lcd.printf("Val = %01.3f ",v);
        hsv2rgb(h,s,v);
        wait_ms(500);
    }
}